/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import com.google.common.base.Predicate;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringValueMatcherColumnSelectorStrategy;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class SingleValueStringVectorValueMatcher
implements VectorValueMatcherFactory {
    private final SingleValueDimensionVectorSelector selector;

    public SingleValueStringVectorValueMatcher(SingleValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    @Nullable
    private static BooleanVectorValueMatcher toBooleanMatcherIfPossible(SingleValueDimensionVectorSelector selector, Predicate<String> predicate) {
        Boolean booleanValue = StringValueMatcherColumnSelectorStrategy.toBooleanIfPossible(selector, false, predicate);
        return booleanValue == null ? null : BooleanVectorValueMatcher.of(selector, booleanValue);
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        String etnValue = NullHandling.emptyToNullIfNeeded((String)value);
        BooleanVectorValueMatcher booleanMatcher = SingleValueStringVectorValueMatcher.toBooleanMatcherIfPossible(this.selector, (Predicate<String>)((Predicate)s -> Objects.equals(s, etnValue)));
        if (booleanMatcher != null) {
            return booleanMatcher;
        }
        IdLookup idLookup = this.selector.idLookup();
        if (idLookup != null) {
            final int id = idLookup.lookupId(etnValue);
            if (id < 0) {
                return BooleanVectorValueMatcher.of(this.selector, false);
            }
            return new BaseVectorValueMatcher(this.selector){
                final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[SingleValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask) {
                    int[] vector = SingleValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        if (vector[rowNum] != id) continue;
                        selection[numRows++] = rowNum;
                    }
                    this.match.setSelectionSize(numRows);
                    assert (this.match.isValid(mask));
                    return this.match;
                }
            };
        }
        return this.makeMatcher((Predicate<String>)((Predicate)s -> Objects.equals(s, etnValue)));
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        return this.makeMatcher(predicateFactory.makeStringPredicate());
    }

    private VectorValueMatcher makeMatcher(final Predicate<String> predicate) {
        BooleanVectorValueMatcher booleanMatcher = SingleValueStringVectorValueMatcher.toBooleanMatcherIfPossible(this.selector, predicate);
        if (booleanMatcher != null) {
            return booleanMatcher;
        }
        if (this.selector.getValueCardinality() > 0) {
            final BitSet checkedIds = new BitSet(this.selector.getValueCardinality());
            final BitSet matchingIds = new BitSet(this.selector.getValueCardinality());
            return new BaseVectorValueMatcher(this.selector){
                private final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[SingleValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask) {
                    int[] vector = SingleValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        boolean matches;
                        int rowNum = mask.getSelection()[i];
                        int id = vector[rowNum];
                        if (checkedIds.get(id)) {
                            matches = matchingIds.get(id);
                        } else {
                            matches = predicate.apply((Object)SingleValueStringVectorValueMatcher.this.selector.lookupName(id));
                            checkedIds.set(id);
                            if (matches) {
                                matchingIds.set(id);
                            }
                        }
                        if (!matches) continue;
                        selection[numRows++] = rowNum;
                    }
                    this.match.setSelectionSize(numRows);
                    assert (this.match.isValid(mask));
                    return this.match;
                }
            };
        }
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[SingleValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                int[] vector = SingleValueStringVectorValueMatcher.this.selector.getRowVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (!predicate.apply((Object)SingleValueStringVectorValueMatcher.this.selector.lookupName(vector[rowNum]))) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

