/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.datasourcemetadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BySegmentSkippingQueryRunner;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import org.apache.druid.timeline.LogicalSegment;
import org.joda.time.ReadableInterval;

public class DataSourceQueryQueryToolChest
extends QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private static final TypeReference<Result<DataSourceMetadataResultValue>> TYPE_REFERENCE = new TypeReference<Result<DataSourceMetadataResultValue>>(){};
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public DataSourceQueryQueryToolChest(GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(DataSourceMetadataQuery query, List<T> segments) {
        if (segments.size() <= 1) {
            return segments;
        }
        LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        return segments.stream().filter(input -> max != null && input.getInterval().overlaps((ReadableInterval)max.getTrueInterval())).collect(Collectors.toList());
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeResults(QueryRunner<Result<DataSourceMetadataResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<DataSourceMetadataResultValue>>(runner){

            @Override
            protected Sequence<Result<DataSourceMetadataResultValue>> doRun(QueryRunner<Result<DataSourceMetadataResultValue>> baseRunner, QueryPlus<Result<DataSourceMetadataResultValue>> input, ResponseContext context) {
                DataSourceMetadataQuery query = (DataSourceMetadataQuery)input.getQuery();
                return Sequences.simple(query.mergeResults(baseRunner.run(input, context).toList()));
            }
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(DataSourceMetadataQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<Result<DataSourceMetadataResultValue>, Result<DataSourceMetadataResultValue>> makePreComputeManipulatorFn(DataSourceMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<DataSourceMetadataResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy getCacheStrategy(DataSourceMetadataQuery query) {
        return null;
    }
}

