/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregator;
import org.apache.druid.query.aggregation.last.FloatLastBufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;

public class FloatLastAggregatorFactory
extends AggregatorFactory {
    private static final Aggregator NIL_AGGREGATOR = new FloatLastAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new FloatLastBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    private final String fieldName;
    private final String name;

    @JsonCreator
    public FloatLastAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new FloatLastAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector("__time"), valueSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new FloatLastBufferAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector("__time"), valueSelector);
    }

    @Override
    public Comparator getComparator() {
        return FloatFirstAggregatorFactory.VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        Long leftTime = (Long)((SerializablePair)lhs).lhs;
        Long rightTime = (Long)((SerializablePair)rhs).lhs;
        if (leftTime >= rightTime) {
            return lhs;
        }
        return rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("FloatLastAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatLastAggregatorFactory(this.name, this.name){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(FloatLastAggregatorFactory.this.name);
                return new FloatLastAggregator(null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        if ((Long)pair.lhs >= this.lastTime) {
                            this.lastTime = (Long)pair.lhs;
                            if (pair.rhs != null) {
                                this.lastValue = ((Float)pair.rhs).floatValue();
                                this.rhsNull = false;
                            } else {
                                this.rhsNull = true;
                            }
                        }
                    }
                };
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(FloatLastAggregatorFactory.this.name);
                return new FloatLastBufferAggregator(null, null){

                    @Override
                    public void putValue(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        buf.putFloat(position, ((Float)pair.rhs).floatValue());
                    }

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        long lastTime = buf.getLong(position);
                        if ((Long)pair.lhs >= lastTime) {
                            if (pair.rhs != null) {
                                this.updateTimeWithValue(buf, position, (Long)pair.lhs);
                            } else {
                                this.updateTimeWithNull(buf, position, (Long)pair.lhs);
                            }
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                };
            }
        };
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new LongFirstAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        if (map.get("rhs") == null) {
            return new SerializablePair((Object)((Number)map.get("lhs")).longValue(), null);
        }
        return new SerializablePair((Object)((Number)map.get("lhs")).longValue(), (Object)Float.valueOf(((Number)map.get("rhs")).floatValue()));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : (Float)((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(2 + fieldNameBytes.length).put((byte)17).put(fieldNameBytes).put((byte)-1).array();
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 13;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatLastAggregatorFactory that = (FloatLastAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName);
    }

    public String toString() {
        return "FloatLastAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

