/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DelegatingBufferAggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableValueDoubleColumnValueSelector;

public class StringColumnDoubleBufferAggregatorWrapper
extends DelegatingBufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final double nullValue;
    private final SettableValueDoubleColumnValueSelector doubleSelector = new SettableValueDoubleColumnValueSelector();

    public StringColumnDoubleBufferAggregatorWrapper(BaseObjectColumnValueSelector selector, Function<BaseDoubleColumnValueSelector, BufferAggregator> delegateBuilder, double nullValue) {
        this.selector = selector;
        this.nullValue = nullValue;
        this.delegate = delegateBuilder.apply(this.doubleSelector);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.getObject();
        if (update == null) {
            this.doubleSelector.setValue(this.nullValue);
            this.delegate.aggregate(buf, position);
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.doubleSelector.setValue(Numbers.tryParseDouble(o, (double)this.nullValue));
                this.delegate.aggregate(buf, position);
            }
        } else {
            this.doubleSelector.setValue(Numbers.tryParseDouble(update, (double)this.nullValue));
            this.delegate.aggregate(buf, position);
        }
    }
}

