/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;

public abstract class BaseQuery<T>
implements Query<T> {
    public static final String QUERY_ID = "queryId";
    public static final String SQL_QUERY_ID = "sqlQueryId";
    private final DataSource dataSource;
    private final boolean descending;
    private final Map<String, Object> context;
    private final QuerySegmentSpec querySegmentSpec;
    private volatile Duration duration;
    private final Granularity granularity;

    public static void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new QueryInterruptedException(new InterruptedException());
        }
    }

    public BaseQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, boolean descending, Map<String, Object> context) {
        this(dataSource, querySegmentSpec, descending, context, Granularities.ALL);
    }

    public BaseQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, boolean descending, Map<String, Object> context, Granularity granularity) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource can't be null");
        Preconditions.checkNotNull((Object)querySegmentSpec, (Object)"querySegmentSpec can't be null");
        Preconditions.checkNotNull((Object)granularity, (Object)"Must specify a granularity");
        this.dataSource = dataSource;
        this.context = context;
        this.querySegmentSpec = querySegmentSpec;
        this.descending = descending;
        this.granularity = granularity;
    }

    @Override
    @JsonProperty
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @JsonProperty
    public boolean isDescending() {
        return this.descending;
    }

    @JsonProperty(value="intervals")
    public QuerySegmentSpec getQuerySegmentSpec() {
        return this.querySegmentSpec;
    }

    @Override
    public QueryRunner<T> getRunner(QuerySegmentWalker walker) {
        return BaseQuery.getQuerySegmentSpecForLookUp(this).lookup(this, walker);
    }

    @VisibleForTesting
    public static QuerySegmentSpec getQuerySegmentSpecForLookUp(BaseQuery query) {
        if (query.getDataSource() instanceof QueryDataSource) {
            QueryDataSource ds = (QueryDataSource)query.getDataSource();
            Query subquery = ds.getQuery();
            if (subquery instanceof BaseQuery) {
                return BaseQuery.getQuerySegmentSpecForLookUp((BaseQuery)subquery);
            }
            throw new IllegalStateException("Invalid subquery type " + subquery.getClass());
        }
        return query.getQuerySegmentSpec();
    }

    @Override
    public List<Interval> getIntervals() {
        return this.querySegmentSpec.getIntervals();
    }

    @Override
    public Duration getDuration() {
        if (this.duration == null) {
            Duration totalDuration = new Duration(0L);
            for (Interval interval : this.querySegmentSpec.getIntervals()) {
                if (interval == null) continue;
                totalDuration = totalDuration.plus((ReadableDuration)interval.toDuration());
            }
            this.duration = totalDuration;
        }
        return this.duration;
    }

    @Override
    @JsonProperty
    public Granularity getGranularity() {
        return this.granularity;
    }

    @Override
    public DateTimeZone getTimezone() {
        return this.granularity instanceof PeriodGranularity ? ((PeriodGranularity)this.granularity).getTimeZone() : DateTimeZone.UTC;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public <ContextType> ContextType getContextValue(String key) {
        return (ContextType)(this.context == null ? null : this.context.get(key));
    }

    @Override
    public <ContextType> ContextType getContextValue(String key, ContextType defaultValue) {
        ContextType retVal = this.getContextValue(key);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public boolean getContextBoolean(String key, boolean defaultValue) {
        return QueryContexts.parseBoolean(this, key, defaultValue);
    }

    @Deprecated
    protected Map<String, Object> computeOverridenContext(Map<String, Object> overrides) {
        return BaseQuery.computeOverriddenContext(this.getContext(), overrides);
    }

    protected static Map<String, Object> computeOverriddenContext(Map<String, Object> context, Map<String, Object> overrides) {
        TreeMap<String, Object> overridden = new TreeMap<String, Object>();
        if (context != null) {
            overridden.putAll(context);
        }
        overridden.putAll(overrides);
        return overridden;
    }

    @Override
    public Ordering<T> getResultOrdering() {
        Ordering retVal = Ordering.natural();
        return this.descending ? retVal.reverse() : retVal;
    }

    @Override
    public String getId() {
        return (String)this.getContextValue(QUERY_ID);
    }

    @Override
    public Query withId(String id) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)QUERY_ID, (Object)id));
    }

    @Override
    @Nullable
    public String getSqlQueryId() {
        return (String)this.getContextValue(SQL_QUERY_ID);
    }

    @Override
    public Query<T> withSqlQueryId(String sqlQueryId) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)SQL_QUERY_ID, (Object)sqlQueryId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseQuery baseQuery = (BaseQuery)o;
        return this.descending == baseQuery.descending && Objects.equals(this.dataSource, baseQuery.dataSource) && Objects.equals(this.context, baseQuery.context) && Objects.equals(this.querySegmentSpec, baseQuery.querySegmentSpec) && Objects.equals(this.duration, baseQuery.duration) && Objects.equals(this.granularity, baseQuery.granularity);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.descending, this.context, this.querySegmentSpec, this.duration, this.granularity);
    }
}

