/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.fmpp.mojo;

import fmpp.Engine;
import fmpp.ProgressListener;
import fmpp.progresslisteners.TerseConsoleProgressListener;
import fmpp.setting.Settings;
import fmpp.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.drill.fmpp.mojo.MavenDataLoader;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class FMPPMojo
extends AbstractMojo {
    private MavenProject project;
    private File templates;
    private File output;
    private File config;
    private String scope;
    private boolean addMavenDataLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            throw new MojoExecutionException("This plugin can only be used inside a project.");
        }
        String outputPath = this.output.getAbsolutePath();
        if (!this.output.exists() && !this.output.mkdirs() || !this.output.isDirectory()) {
            throw new MojoFailureException("can not write to output dir: " + outputPath);
        }
        String templatesPath = this.templates.getAbsolutePath();
        if (!this.templates.exists() || !this.templates.isDirectory()) {
            throw new MojoFailureException("templates not found in dir: " + outputPath);
        }
        switch (this.scope) {
            case "compile": {
                this.project.addCompileSourceRoot(outputPath);
                break;
            }
            case "test": {
                this.project.addTestCompileSourceRoot(outputPath);
                break;
            }
            default: {
                throw new MojoFailureException("scope must be compile or test");
            }
        }
        final Stopwatch sw = Stopwatch.createStarted();
        try {
            this.getLog().info((CharSequence)String.format("Freemarker generation:\n scope: %s,\n config: %s,\n templates: %s", this.scope, this.config.getAbsolutePath(), templatesPath));
            final File tmp = Files.createTempDirectory("freemarker-tmp", new FileAttribute[0]).toFile();
            String tmpPath = tmp.getAbsolutePath();
            final String tmpPathNormalized = tmpPath.endsWith(File.separator) ? tmpPath : tmpPath + File.separator;
            Settings settings = new Settings(new File("."));
            settings.set("sourceRoot", (Object)templatesPath);
            settings.set("outputRoot", (Object)tmp.getAbsolutePath());
            settings.load(this.config);
            settings.addProgressListener((ProgressListener)new TerseConsoleProgressListener());
            settings.addProgressListener(new ProgressListener(){

                public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) throws Exception {
                    if (event == 4) {
                        FMPPMojo.this.getLog().info((CharSequence)String.format("Freemarker generation took %dms", sw.elapsed(TimeUnit.MILLISECONDS)));
                        sw.reset();
                        Report report = FMPPMojo.this.moveIfChanged(tmp, tmpPathNormalized);
                        if (!tmp.delete()) {
                            throw new MojoFailureException(String.format("can not delete %s", tmp));
                        }
                        FMPPMojo.this.getLog().info((CharSequence)String.format("Incremental output update took %dms", sw.elapsed(TimeUnit.MILLISECONDS)));
                        FMPPMojo.this.getLog().info((CharSequence)String.format("new: %d", report.newFiles));
                        FMPPMojo.this.getLog().info((CharSequence)String.format("changed: %d", report.changedFiles));
                        FMPPMojo.this.getLog().info((CharSequence)String.format("unchanged: %d", report.unchangedFiles));
                    }
                }
            });
            if (this.addMavenDataLoader) {
                this.getLog().info((CharSequence)"Adding maven data loader");
                settings.setEngineAttribute("maven.data", (Object)new MavenDataLoader.MavenData(this.project));
                settings.add("data", (Object)String.format("maven: %s()", MavenDataLoader.class.getName()));
            }
            settings.execute();
        }
        catch (Exception e) {
            throw new MojoFailureException(MiscUtil.causeMessages((Throwable)e), (Throwable)e);
        }
    }

    private Report moveIfChanged(File root, String tmpPath) throws MojoFailureException, IOException {
        Report report = new Report();
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                report.add(this.moveIfChanged(file, tmpPath));
                if (file.delete()) continue;
                throw new MojoFailureException(String.format("can not delete %s", file));
            }
            String absPath = file.getAbsolutePath();
            if (!absPath.startsWith(tmpPath)) {
                throw new MojoFailureException(String.format("%s should start with %s", absPath, tmpPath));
            }
            String relPath = absPath.substring(tmpPath.length());
            File outputFile = new File(this.output, relPath);
            if (!outputFile.exists()) {
                report.addNew();
            } else if (!FileUtils.contentEquals((File)file, (File)outputFile)) {
                this.getLog().info((CharSequence)String.format("%s has changed", relPath));
                if (!outputFile.delete()) {
                    throw new MojoFailureException(String.format("can not delete %s", outputFile));
                }
                report.addChanged();
            } else {
                report.addUnchanged();
            }
            if (!outputFile.exists()) {
                File parentDir = outputFile.getParentFile();
                if (parentDir.exists() && !parentDir.isDirectory()) {
                    throw new MojoFailureException(String.format("can not move %s to %s as %s is not a dir", file, outputFile, parentDir));
                }
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new MojoFailureException(String.format("can not move %s to %s as dir %s can not be created", file, outputFile, parentDir));
                }
                FileUtils.moveFile((File)file, (File)outputFile);
                continue;
            }
            if (file.delete()) continue;
            throw new MojoFailureException(String.format("can not delete %s", file));
        }
        return report;
    }

    private static final class Report {
        int changedFiles;
        int unchangedFiles;
        int newFiles;

        Report(int changedFiles, int unchangedFiles, int newFiles) {
            this.changedFiles = changedFiles;
            this.unchangedFiles = unchangedFiles;
            this.newFiles = newFiles;
        }

        public Report() {
            this(0, 0, 0);
        }

        void add(Report other) {
            this.changedFiles += other.changedFiles;
            this.unchangedFiles += other.unchangedFiles;
            this.newFiles += other.newFiles;
        }

        public void addChanged() {
            ++this.changedFiles;
        }

        public void addNew() {
            ++this.newFiles;
        }

        public void addUnchanged() {
            ++this.unchangedFiles;
        }
    }
}

