/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import oadd.org.apache.calcite.avatica.AvaticaDatabaseMetaData;
import oadd.org.apache.calcite.avatica.util.Quoting;
import oadd.org.apache.drill.common.Version;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.client.ServerMethod;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillDatabaseMetaData;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Throwables;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;

public class DrillDatabaseMetaDataImpl
extends AvaticaDatabaseMetaData
implements DrillDatabaseMetaData {
    private volatile UserProtos.ServerMeta serverMeta;
    private volatile Set<SQLConvertSupport> convertSupport;

    protected DrillDatabaseMetaDataImpl(DrillConnectionImpl connection) {
        super(connection);
    }

    protected void checkOpen() throws AlreadyClosedSqlException, SQLException {
        if (this.getConnection().isClosed()) {
            throw new AlreadyClosedSqlException("DatabaseMetaData's Connection is already closed.");
        }
    }

    private boolean getServerMetaSupported() throws SQLException {
        DrillConnectionImpl connection = (DrillConnectionImpl)this.getConnection();
        return !connection.getConfig().isServerMetadataDisabled() && connection.getClient().getSupportedMethods().contains((Object)ServerMethod.GET_SERVER_META);
    }

    private String getServerName() throws SQLException {
        DrillConnectionImpl connection = (DrillConnectionImpl)this.getConnection();
        return connection.getClient().getServerName();
    }

    private Version getServerVersion() throws SQLException {
        DrillConnectionImpl connection = (DrillConnectionImpl)this.getConnection();
        return connection.getClient().getServerVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserProtos.ServerMeta getServerMeta() throws SQLException {
        assert (this.getServerMetaSupported());
        if (this.serverMeta == null) {
            DrillDatabaseMetaDataImpl drillDatabaseMetaDataImpl = this;
            synchronized (drillDatabaseMetaDataImpl) {
                if (this.serverMeta == null) {
                    DrillConnectionImpl connection = (DrillConnectionImpl)this.getConnection();
                    try {
                        UserProtos.GetServerMetaResp resp = (UserProtos.GetServerMetaResp)connection.getClient().getServerMeta().get();
                        if (resp.getStatus() != UserProtos.RequestStatus.OK) {
                            UserBitShared.DrillPBError drillError = resp.getError();
                            throw new SQLException("Error when getting server meta: " + drillError.getMessage());
                        }
                        this.serverMeta = resp.getServerMeta();
                        this.convertSupport = SQLConvertSupport.toSQLConvertSupport(this.serverMeta.getConvertSupportList());
                    }
                    catch (InterruptedException e) {
                        throw new SQLException("Interrupted when getting server meta", e);
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause == null) {
                            throw new AssertionError("Something unknown happened", e);
                        }
                        Throwables.throwIfUnchecked(cause);
                        throw new SQLException("Error when getting server meta", cause);
                    }
                }
            }
        }
        return this.serverMeta;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        this.checkOpen();
        return super.allProceduresAreCallable();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.allTablesAreSelectable();
        }
        return this.getServerMeta().getAllTablesSelectable();
    }

    @Override
    public String getURL() throws SQLException {
        this.checkOpen();
        return super.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        this.checkOpen();
        return super.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.isReadOnly();
        }
        return this.getServerMeta().getReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return true;
        }
        return this.getServerMeta().getNullCollation() == UserProtos.NullCollation.NC_HIGH;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return false;
        }
        return this.getServerMeta().getNullCollation() == UserProtos.NullCollation.NC_LOW;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return false;
        }
        return this.getServerMeta().getNullCollation() == UserProtos.NullCollation.NC_AT_START;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return false;
        }
        return this.getServerMeta().getNullCollation() == UserProtos.NullCollation.NC_AT_END;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        this.checkOpen();
        String name = this.getServerName();
        if (name == null) {
            return super.getDatabaseProductName();
        }
        return name;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.checkOpen();
        Version version = this.getServerVersion();
        if (version == null) {
            return super.getDatabaseProductVersion();
        }
        return version.getVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        this.checkOpen();
        return super.getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        this.checkOpen();
        return super.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return super.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return super.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        this.checkOpen();
        return super.usesLocalFiles();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        this.checkOpen();
        return super.usesLocalFilePerTable();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsMixedCaseIdentifiers();
        }
        return this.getServerMeta().getIdentifierCasing() == UserProtos.IdentifierCasing.IC_SUPPORTS_MIXED;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.storesUpperCaseIdentifiers();
        }
        return this.getServerMeta().getIdentifierCasing() == UserProtos.IdentifierCasing.IC_STORES_UPPER;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.storesLowerCaseIdentifiers();
        }
        return this.getServerMeta().getIdentifierCasing() == UserProtos.IdentifierCasing.IC_STORES_LOWER;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.storesMixedCaseIdentifiers();
        }
        return this.getServerMeta().getIdentifierCasing() == UserProtos.IdentifierCasing.IC_STORES_MIXED;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsMixedCaseQuotedIdentifiers();
        }
        return this.getServerMeta().getQuotedIdentifierCasing() == UserProtos.IdentifierCasing.IC_SUPPORTS_MIXED;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.storesUpperCaseQuotedIdentifiers();
        }
        return this.getServerMeta().getQuotedIdentifierCasing() == UserProtos.IdentifierCasing.IC_STORES_UPPER;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.storesLowerCaseQuotedIdentifiers();
        }
        return this.getServerMeta().getQuotedIdentifierCasing() == UserProtos.IdentifierCasing.IC_STORES_LOWER;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.storesMixedCaseQuotedIdentifiers();
        }
        return this.getServerMeta().getQuotedIdentifierCasing() == UserProtos.IdentifierCasing.IC_STORES_MIXED;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return Quoting.BACK_TICK.string;
        }
        return this.getServerMeta().getIdentifierQuoteString();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getSQLKeywords();
        }
        return Joiner.on(",").join(this.getServerMeta().getSqlKeywordsList());
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getNumericFunctions();
        }
        return Joiner.on(",").join(this.getServerMeta().getNumericFunctionsList());
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getStringFunctions();
        }
        return Joiner.on(",").join(this.getServerMeta().getStringFunctionsList());
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getSystemFunctions();
        }
        return Joiner.on(",").join(this.getServerMeta().getSystemFunctionsList());
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getTimeDateFunctions();
        }
        return Joiner.on(",").join(this.getServerMeta().getDateTimeFunctionsList());
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getSearchStringEscape();
        }
        return this.getServerMeta().getSearchEscapeString();
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getExtraNameCharacters();
        }
        return this.getServerMeta().getSpecialCharacters();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkOpen();
        return super.supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkOpen();
        return super.supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsColumnAliasing();
        }
        return this.getServerMeta().getColumnAliasingSupported();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.nullPlusNonNullIsNull();
        }
        return this.getServerMeta().getNullPlusNonNullEqualsNull();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsConvert();
        }
        this.getServerMeta();
        return !this.convertSupport.isEmpty();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsConvert(fromType, toType);
        }
        this.getServerMeta();
        return this.convertSupport.contains(new SQLConvertSupport(fromType, toType));
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsTableCorrelationNames();
        }
        return this.getServerMeta().getCorrelationNamesSupport() == UserProtos.CorrelationNamesSupport.CN_ANY || this.getServerMeta().getCorrelationNamesSupport() == UserProtos.CorrelationNamesSupport.CN_DIFFERENT_NAMES;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsDifferentTableCorrelationNames();
        }
        return this.getServerMeta().getCorrelationNamesSupport() == UserProtos.CorrelationNamesSupport.CN_DIFFERENT_NAMES;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsExpressionsInOrderBy();
        }
        return this.getServerMeta().getOrderBySupportList().contains(UserProtos.OrderBySupport.OB_EXPRESSION);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsOrderByUnrelated();
        }
        return this.getServerMeta().getOrderBySupportList().contains(UserProtos.OrderBySupport.OB_UNRELATED);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsGroupBy();
        }
        return this.getServerMeta().getGroupBySupport() != UserProtos.GroupBySupport.GB_NONE;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsGroupByUnrelated();
        }
        return this.getServerMeta().getGroupBySupport() == UserProtos.GroupBySupport.GB_UNRELATED;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsGroupByBeyondSelect();
        }
        return this.getServerMeta().getGroupBySupport() == UserProtos.GroupBySupport.GB_BEYOND_SELECT;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsLikeEscapeClause();
        }
        return this.getServerMeta().getLikeEscapeClauseSupported();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        this.checkOpen();
        return super.supportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        this.checkOpen();
        return super.supportsMultipleTransactions();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        this.checkOpen();
        return super.supportsNonNullableColumns();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkOpen();
        return super.supportsMinimumSQLGrammar();
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkOpen();
        return super.supportsCoreSQLGrammar();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkOpen();
        return super.supportsExtendedSQLGrammar();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkOpen();
        return super.supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkOpen();
        return super.supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        this.checkOpen();
        return super.supportsANSI92FullSQL();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkOpen();
        return super.supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsOuterJoins();
        }
        return this.getServerMeta().getOuterJoinSupportCount() > 0;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsFullOuterJoins();
        }
        return this.getServerMeta().getOuterJoinSupportList().contains(UserProtos.OuterJoinSupport.OJ_FULL);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsFullOuterJoins();
        }
        return this.getServerMeta().getOuterJoinSupportCount() > 0 && !this.getServerMeta().getOuterJoinSupportList().contains(UserProtos.OuterJoinSupport.OJ_FULL);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getSchemaTerm();
        }
        return this.getServerMeta().getSchemaTerm();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        this.checkOpen();
        return super.getProcedureTerm();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getCatalogTerm();
        }
        return this.getServerMeta().getCatalogTerm();
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.isCatalogAtStart();
        }
        return this.getServerMeta().getCatalogAtStart();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getCatalogSeparator();
        }
        return this.getServerMeta().getCatalogSeparator();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkOpen();
        return super.supportsSchemasInDataManipulation();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkOpen();
        return super.supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkOpen();
        return super.supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkOpen();
        return super.supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkOpen();
        return super.supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkOpen();
        return super.supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkOpen();
        return super.supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkOpen();
        return super.supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkOpen();
        return super.supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkOpen();
        return super.supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        this.checkOpen();
        return super.supportsPositionedDelete();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        this.checkOpen();
        return super.supportsPositionedUpdate();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsSelectForUpdate();
        }
        return this.getServerMeta().getSelectForUpdateSupported();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        this.checkOpen();
        return super.supportsStoredProcedures();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsSubqueriesInComparisons();
        }
        return this.getServerMeta().getSubquerySupportList().contains(UserProtos.SubQuerySupport.SQ_IN_COMPARISON);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsSubqueriesInExists();
        }
        return this.getServerMeta().getSubquerySupportList().contains(UserProtos.SubQuerySupport.SQ_IN_EXISTS);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsSubqueriesInIns();
        }
        return this.getServerMeta().getSubquerySupportList().contains(UserProtos.SubQuerySupport.SQ_IN_INSERT);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsSubqueriesInQuantifieds();
        }
        return this.getServerMeta().getSubquerySupportList().contains(UserProtos.SubQuerySupport.SQ_IN_QUANTIFIED);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsCorrelatedSubqueries();
        }
        return this.getServerMeta().getSubquerySupportList().contains(UserProtos.SubQuerySupport.SQ_CORRELATED);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsUnion();
        }
        return this.getServerMeta().getUnionSupportList().contains(UserProtos.UnionSupport.U_UNION);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsUnionAll();
        }
        return this.getServerMeta().getUnionSupportList().contains(UserProtos.UnionSupport.U_UNION_ALL);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkOpen();
        return super.supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkOpen();
        return super.supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkOpen();
        return super.supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkOpen();
        return super.supportsOpenStatementsAcrossRollback();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxBinaryLiteralLength();
        }
        return this.getServerMeta().getMaxBinaryLiteralLength();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxCharLiteralLength();
        }
        return this.getServerMeta().getMaxCharLiteralLength();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxColumnNameLength();
        }
        return this.getServerMeta().getMaxColumnNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxColumnsInGroupBy();
        }
        return this.getServerMeta().getMaxColumnsInGroupBy();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        this.checkOpen();
        return super.getMaxColumnsInIndex();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxColumnsInOrderBy();
        }
        return this.getServerMeta().getMaxColumnsInOrderBy();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxColumnsInSelect();
        }
        return this.getServerMeta().getMaxColumnsInSelect();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        this.checkOpen();
        return super.getMaxColumnsInTable();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        this.checkOpen();
        return super.getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxCursorNameLength();
        }
        return this.getServerMeta().getMaxCursorNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        this.checkOpen();
        return super.getMaxIndexLength();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxSchemaNameLength();
        }
        return this.getServerMeta().getMaxSchemaNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        this.checkOpen();
        return super.getMaxProcedureNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxCatalogNameLength();
        }
        return this.getServerMeta().getMaxCatalogNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxRowSize();
        }
        return this.getServerMeta().getMaxRowSize();
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.doesMaxRowSizeIncludeBlobs();
        }
        return this.getServerMeta().getBlobIncludedInMaxRowSize();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxStatementLength();
        }
        return this.getServerMeta().getMaxStatementLength();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxStatements();
        }
        return this.getServerMeta().getMaxStatements();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxTableNameLength();
        }
        return this.getServerMeta().getMaxTableNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxTablesInSelect();
        }
        return this.getServerMeta().getMaxTablesInSelect();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.getMaxUserNameLength();
        }
        return this.getServerMeta().getMaxUserNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        this.checkOpen();
        return super.getDefaultTransactionIsolation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        this.checkOpen();
        if (!this.getServerMetaSupported()) {
            return super.supportsTransactions();
        }
        return this.getServerMeta().getTransactionSupported();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        this.checkOpen();
        return super.supportsTransactionIsolationLevel(level);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkOpen();
        return super.supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkOpen();
        return super.supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkOpen();
        return super.dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkOpen();
        return super.dataDefinitionIgnoredInTransactions();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.checkOpen();
        return super.getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.checkOpen();
        return super.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.checkOpen();
        try {
            return super.getTables(catalog, schemaPattern, tableNamePattern, types);
        }
        catch (DrillRuntimeException e) {
            Throwables.throwIfInstanceOf(e.getCause(), SQLException.class);
            throw e;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.checkOpen();
        try {
            return super.getSchemas();
        }
        catch (DrillRuntimeException e) {
            Throwables.throwIfInstanceOf(e.getCause(), SQLException.class);
            throw e;
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.checkOpen();
        try {
            return super.getCatalogs();
        }
        catch (DrillRuntimeException e) {
            Throwables.throwIfInstanceOf(e.getCause(), SQLException.class);
            throw e;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.checkOpen();
        return super.getTableTypes();
    }

    @Override
    public ResultSet getColumns(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkOpen();
        try {
            return super.getColumns(catalog, schema, table, columnNamePattern);
        }
        catch (DrillRuntimeException e) {
            Throwables.throwIfInstanceOf(e.getCause(), SQLException.class);
            throw e;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkOpen();
        return super.getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkOpen();
        return super.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.checkOpen();
        return super.getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.checkOpen();
        return super.getVersionColumns(catalog, schema, table);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkOpen();
        return super.getPrimaryKeys(catalog, schema, table);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkOpen();
        return super.getImportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkOpen();
        return super.getExportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.checkOpen();
        return super.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.checkOpen();
        return super.getTypeInfo();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkOpen();
        return super.getIndexInfo(catalog, schema, table, unique, approximate);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        this.checkOpen();
        return super.supportsResultSetType(type);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        this.checkOpen();
        return super.supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.ownUpdatesAreVisible(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("ownUpdatesAreVisible(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.ownDeletesAreVisible(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("ownDeletesAreVisible(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.ownInsertsAreVisible(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("ownInsertsAreVisible(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.othersUpdatesAreVisible(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("othersUpdatesAreVisible(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.othersDeletesAreVisible(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("othersDeletesAreVisible(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.othersInsertsAreVisible(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("othersInsertsAreVisible(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.updatesAreDetected(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("updatesAreDetected(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.deletesAreDetected(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("deletesAreDetected(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        this.checkOpen();
        try {
            return super.insertsAreDetected(type);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("insertsAreDetected(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        this.checkOpen();
        return super.supportsBatchUpdates();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.checkOpen();
        return super.getUDTs(catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return super.getConnection();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        this.checkOpen();
        return super.supportsSavepoints();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        this.checkOpen();
        return super.supportsNamedParameters();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        this.checkOpen();
        return super.supportsMultipleOpenResults();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        this.checkOpen();
        return super.supportsGetGeneratedKeys();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.checkOpen();
        return super.getSuperTypes(catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkOpen();
        return super.getSuperTables(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.checkOpen();
        return super.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        this.checkOpen();
        try {
            return super.supportsResultSetHoldability(holdability);
        }
        catch (RuntimeException e) {
            if ("todo: implement this method".equals(e.getMessage())) {
                throw new SQLFeatureNotSupportedException("supportsResultSetHoldability(int) is not supported", e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public int getResultSetHoldability() {
        try {
            this.checkOpen();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getResultSetHoldability();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        this.checkOpen();
        Version version = this.getServerVersion();
        if (version == null) {
            return super.getDatabaseMajorVersion();
        }
        return version.getMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        this.checkOpen();
        Version version = this.getServerVersion();
        if (version == null) {
            return super.getDatabaseMinorVersion();
        }
        return version.getMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        this.checkOpen();
        return super.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        this.checkOpen();
        return super.getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        this.checkOpen();
        return super.getSQLStateType();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkOpen();
        return super.locatorsUpdateCopy();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        this.checkOpen();
        return super.supportsStatementPooling();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        this.checkOpen();
        return super.getRowIdLifetime();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.checkOpen();
        return super.getSchemas(catalog, schemaPattern);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        this.checkOpen();
        return super.supportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        this.checkOpen();
        return super.autoCommitFailureClosesAllResultSets();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this.checkOpen();
        return super.getClientInfoProperties();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.checkOpen();
        return super.getFunctions(catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.checkOpen();
        return super.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkOpen();
        return super.getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this.checkOpen();
        return super.generatedKeyAlwaysReturned();
    }

    private static final class SQLConvertSupport {
        public final int from;
        public final int to;

        public SQLConvertSupport(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SQLConvertSupport)) {
                return false;
            }
            SQLConvertSupport other = (SQLConvertSupport)obj;
            return this.from == other.from && this.to == other.to;
        }

        public static final Set<SQLConvertSupport> toSQLConvertSupport(Iterable<UserProtos.ConvertSupport> convertSupportIterable) {
            ImmutableSet.Builder sqlConvertSupportSet = ImmutableSet.builder();
            for (UserProtos.ConvertSupport convertSupport : convertSupportIterable) {
                try {
                    sqlConvertSupportSet.add(new SQLConvertSupport(SQLConvertSupport.toSQLType(convertSupport.getFrom()), SQLConvertSupport.toSQLType(convertSupport.getTo())));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return sqlConvertSupportSet.build();
        }

        private static int toSQLType(TypeProtos.MinorType minorType) {
            String sqlTypeName = Types.getSqlTypeName(Types.optional(minorType));
            return Types.getJdbcTypeCode(sqlTypeName);
        }
    }
}

