/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.serializer.avro;

import java.util.HashSet;
import java.util.Set;
import oadd.org.apache.avro.Schema;
import oadd.org.apache.avro.io.DatumReader;
import oadd.org.apache.avro.io.DatumWriter;
import oadd.org.apache.avro.reflect.ReflectData;
import oadd.org.apache.avro.reflect.ReflectDatumReader;
import oadd.org.apache.avro.reflect.ReflectDatumWriter;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.io.serializer.avro.AvroReflectSerializable;
import oadd.org.apache.hadoop.io.serializer.avro.AvroSerialization;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AvroReflectSerialization
extends AvroSerialization<Object> {
    @InterfaceAudience.Private
    public static final String AVRO_REFLECT_PACKAGES = "avro.reflect.pkgs";
    private Set<String> packages;

    @Override
    @InterfaceAudience.Private
    public synchronized boolean accept(Class<?> c) {
        if (this.packages == null) {
            this.getPackages();
        }
        return AvroReflectSerializable.class.isAssignableFrom(c) || c.getPackage() != null && this.packages.contains(c.getPackage().getName());
    }

    private void getPackages() {
        String[] pkgList = this.getConf().getStrings(AVRO_REFLECT_PACKAGES);
        this.packages = new HashSet<String>();
        if (pkgList != null) {
            for (String pkg : pkgList) {
                this.packages.add(pkg.trim());
            }
        }
    }

    @Override
    @InterfaceAudience.Private
    public DatumReader getReader(Class<Object> clazz) {
        try {
            return new ReflectDatumReader(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @InterfaceAudience.Private
    public Schema getSchema(Object t) {
        return ReflectData.get().getSchema(t.getClass());
    }

    @Override
    @InterfaceAudience.Private
    public DatumWriter getWriter(Class<Object> clazz) {
        return new ReflectDatumWriter();
    }
}

