/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io;

import java.io.IOException;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.io.MapFile;
import oadd.org.apache.hadoop.io.NullWritable;
import oadd.org.apache.hadoop.io.SequenceFile;
import oadd.org.apache.hadoop.io.WritableComparable;
import oadd.org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SetFile
extends MapFile {
    protected SetFile() {
    }

    public static class Reader
    extends MapFile.Reader {
        public Reader(FileSystem fs, String dirName, Configuration conf) throws IOException {
            super(fs, dirName, conf);
        }

        public Reader(FileSystem fs, String dirName, WritableComparator comparator, Configuration conf) throws IOException {
            super(new Path(dirName), conf, Reader.comparator(comparator));
        }

        @Override
        public boolean seek(WritableComparable key) throws IOException {
            return super.seek(key);
        }

        public boolean next(WritableComparable key) throws IOException {
            return this.next(key, NullWritable.get());
        }

        public WritableComparable get(WritableComparable key) throws IOException {
            if (this.seek(key)) {
                this.next(key);
                return key;
            }
            return null;
        }
    }

    public static class Writer
    extends MapFile.Writer {
        public Writer(FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass) throws IOException {
            super(new Configuration(), fs, dirName, keyClass, NullWritable.class);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, SequenceFile.CompressionType compress) throws IOException {
            this(conf, fs, dirName, WritableComparator.get(keyClass, conf), compress);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, SequenceFile.CompressionType compress) throws IOException {
            super(conf, new Path(dirName), Writer.comparator(comparator), Writer.valueClass(NullWritable.class), Writer.compression(compress));
        }

        public void append(WritableComparable key) throws IOException {
            this.append(key, NullWritable.get());
        }
    }
}

