/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TimeWriter;

public class TimeHolderReaderImpl
extends AbstractFieldReader {
    private TimeHolder holder;

    public TimeHolderReaderImpl(TimeHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TimeHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(TimeHolder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeHolder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalTime readLocalTime() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalTime();
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalTime();
    }

    @Override
    public void copyAsValue(TimeWriter writer) {
        if (this.isSet()) {
            writer.writeTime(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        TimeWriter impl = writer.time(name);
        if (this.isSet()) {
            impl.writeTime(this.holder.value);
        }
    }
}

