/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableIntervalVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableIntervalWriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import oadd.org.joda.time.Period;

public class NullableIntervalReaderImpl
extends AbstractFieldReader {
    private final NullableIntervalVector vector;

    public NullableIntervalReaderImpl(NullableIntervalVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(IntervalWriter writer) {
        NullableIntervalWriterImpl impl = (NullableIntervalWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableIntervalWriterImpl impl = (NullableIntervalWriterImpl)writer.interval(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(ValueHolder h2) {
        this.read((NullableIntervalHolder)h2);
    }

    @Override
    public void read(NullableIntervalHolder h2) {
        this.vector.getAccessor().get(this.idx(), h2);
    }

    @Override
    public Period readPeriod() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

