/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.IntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import oadd.org.joda.time.Period;

public class IntervalHolderReaderImpl
extends AbstractFieldReader {
    private IntervalHolder holder;

    public IntervalHolderReaderImpl(IntervalHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return IntervalHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntervalHolder h2) {
        h2.months = this.holder.months;
        h2.days = this.holder.days;
        h2.milliseconds = this.holder.milliseconds;
    }

    @Override
    public void read(NullableIntervalHolder h2) {
        h2.months = this.holder.months;
        h2.days = this.holder.days;
        h2.milliseconds = this.holder.milliseconds;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Period readPeriod() {
        Period p = new Period();
        return p.plusMonths(this.holder.months).plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        Period p = new Period();
        return p.plusMonths(this.holder.months).plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public void copyAsValue(IntervalWriter writer) {
        if (this.isSet()) {
            writer.writeInterval(this.holder.months, this.holder.days, this.holder.milliseconds);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        IntervalWriter impl = writer.interval(name);
        if (this.isSet()) {
            impl.writeInterval(this.holder.months, this.holder.days, this.holder.milliseconds);
        }
    }
}

