/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import java.util.List;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractTupleReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;

public class MapReader
extends AbstractTupleReader {
    protected final ColumnMetadata schema;
    private final VectorAccessor mapAccessor;

    protected MapReader(ColumnMetadata schema, AbstractObjectReader[] readers) {
        this(schema, null, readers);
    }

    protected MapReader(ColumnMetadata schema, VectorAccessor mapAccessor, AbstractObjectReader[] readers) {
        super(readers);
        this.schema = schema;
        this.mapAccessor = mapAccessor;
    }

    public static AbstractTupleReader.TupleObjectReader build(ColumnMetadata schema, VectorAccessor mapAccessor, AbstractObjectReader[] readers) {
        MapReader mapReader = new MapReader(schema, mapAccessor, readers);
        mapReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new AbstractTupleReader.TupleObjectReader(mapReader);
    }

    public static AbstractObjectReader build(ColumnMetadata schema, VectorAccessor mapAccessor, List<AbstractObjectReader> readers) {
        AbstractObjectReader[] readerArray = new AbstractObjectReader[readers.size()];
        return MapReader.build(schema, mapAccessor, readers.toArray(readerArray));
    }

    @Override
    public void bindIndex(ColumnReaderIndex index) {
        if (this.mapAccessor != null) {
            this.mapAccessor.bind(index);
        }
        super.bindIndex(index);
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.schema.tupleSchema();
    }
}

