/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.sql.Time;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.NullableTimeVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import oadd.org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import oadd.org.joda.time.DateTimeZone;
import oadd.org.joda.time.LocalTime;

public class NullableTimeAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.TIME);
    private final NullableTimeVector.Accessor ac;

    public NullableTimeAccessor(NullableTimeVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Time.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getTime(index);
    }

    @Override
    public Time getTime(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalTime time = new LocalTime((long)this.ac.get(index), DateTimeZone.UTC);
        return new TimePrintMillis(time.toDateTimeToday().getMillis());
    }
}

