/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.math.BigDecimal;
import java.util.Arrays;
import oadd.org.apache.drill.exec.vector.accessor.AbstractKeyAccessor;
import oadd.org.apache.drill.exec.vector.accessor.DictReader;
import oadd.org.apache.drill.exec.vector.accessor.KeyAccessor;
import oadd.org.apache.drill.exec.vector.accessor.ScalarReader;
import oadd.org.joda.time.Instant;
import oadd.org.joda.time.LocalDate;
import oadd.org.joda.time.LocalTime;
import oadd.org.joda.time.Period;

public class KeyAccessors {
    public static KeyAccessor getAccessor(DictReader dictReader, ScalarReader keyReader) {
        switch (keyReader.valueType()) {
            case BOOLEAN: {
                return new BooleanKeyAccessor(dictReader, keyReader);
            }
            case BYTES: {
                return new BytesKeyAccessor(dictReader, keyReader);
            }
            case DECIMAL: {
                return new DecimalKeyAccessor(dictReader, keyReader);
            }
            case DOUBLE: {
                return new DoubleKeyAccessor(dictReader, keyReader);
            }
            case INTEGER: {
                return new IntegerKeyAccessor(dictReader, keyReader);
            }
            case LONG: {
                return new LongKeyAccessor(dictReader, keyReader);
            }
            case PERIOD: {
                return new PeriodKeyAccessor(dictReader, keyReader);
            }
            case STRING: {
                return new StringKeyAccessor(dictReader, keyReader);
            }
            case DATE: {
                return new DateKeyAccessor(dictReader, keyReader);
            }
            case TIME: {
                return new TimeKeyAccessor(dictReader, keyReader);
            }
            case TIMESTAMP: {
                return new TimestampKeyAccessor(dictReader, keyReader);
            }
        }
        throw new IllegalStateException("Unexpected key type: " + (Object)((Object)keyReader.valueType()));
    }

    public static class TimestampKeyAccessor
    extends AbstractKeyAccessor {
        public TimestampKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(Instant key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!key.equals(this.keyReader.getTimestamp())) continue;
                return true;
            }
            return false;
        }
    }

    public static class TimeKeyAccessor
    extends AbstractKeyAccessor {
        public TimeKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(LocalTime key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!key.equals(this.keyReader.getTime())) continue;
                return true;
            }
            return false;
        }
    }

    public static class DateKeyAccessor
    extends AbstractKeyAccessor {
        public DateKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(LocalDate key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!key.equals(this.keyReader.getDate())) continue;
                return true;
            }
            return false;
        }
    }

    public static class PeriodKeyAccessor
    extends AbstractKeyAccessor {
        public PeriodKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(Period key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!key.equals(this.keyReader.getPeriod())) continue;
                return true;
            }
            return false;
        }
    }

    public static class DecimalKeyAccessor
    extends AbstractKeyAccessor {
        public DecimalKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(BigDecimal key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!key.equals(this.keyReader.getDecimal())) continue;
                return true;
            }
            return false;
        }
    }

    public static class BytesKeyAccessor
    extends AbstractKeyAccessor {
        public BytesKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(byte[] key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!Arrays.equals(key, this.keyReader.getBytes())) continue;
                return true;
            }
            return false;
        }
    }

    public static class StringKeyAccessor
    extends AbstractKeyAccessor {
        public StringKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(String key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (!key.equals(this.keyReader.getString())) continue;
                return true;
            }
            return false;
        }
    }

    public static class DoubleKeyAccessor
    extends AbstractKeyAccessor {
        public DoubleKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(double key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (key != this.keyReader.getDouble()) continue;
                return true;
            }
            return false;
        }
    }

    public static class LongKeyAccessor
    extends AbstractKeyAccessor {
        public LongKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(long key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (key != this.keyReader.getLong()) continue;
                return true;
            }
            return false;
        }
    }

    public static class IntegerKeyAccessor
    extends AbstractKeyAccessor {
        public IntegerKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(int key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (key != this.keyReader.getInt()) continue;
                return true;
            }
            return false;
        }
    }

    public static class BooleanKeyAccessor
    extends AbstractKeyAccessor {
        public BooleanKeyAccessor(DictReader dictReader, ScalarReader keyReader) {
            super(dictReader, keyReader);
        }

        @Override
        public boolean find(boolean key) {
            this.dictReader.rewind();
            while (this.dictReader.next()) {
                if (key != this.keyReader.getBoolean()) continue;
                return true;
            }
            return false;
        }
    }
}

