/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.BitVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class BitAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.BIT);
    private final BitVector.Accessor ac;

    public BitAccessor(BitVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return Boolean.class;
    }

    @Override
    public Object getObject(int index) {
        return this.ac.getObject(index);
    }

    @Override
    public int getInt(int index) {
        return this.ac.get(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return 1 == this.ac.get(index);
    }
}

