/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.serialization;

import java.io.IOException;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.ObjectReader;
import oadd.com.fasterxml.jackson.databind.ObjectWriter;
import oadd.org.apache.drill.exec.serialization.InstanceSerializer;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;

public class JacksonSerializer<T>
implements InstanceSerializer<T> {
    private final ObjectReader reader;
    private final ObjectWriter writer;

    public JacksonSerializer(ObjectMapper mapper, Class<T> klazz) {
        this.reader = mapper.readerFor(klazz);
        this.writer = mapper.writer();
    }

    @Override
    public T deserialize(byte[] raw) throws IOException {
        return this.reader.readValue(raw);
    }

    @Override
    public byte[] serialize(T instance) throws IOException {
        return this.writer.writeValueAsBytes(instance);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JacksonSerializer && obj.getClass().equals(this.getClass())) {
            JacksonSerializer other = (JacksonSerializer)obj;
            return Objects.equal(this.reader, other.reader) && Objects.equal(this.writer, other.writer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.reader, this.writer);
    }
}

