/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security.plain;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;

class PlainServer
implements SaslServer {
    private static final String UTF_8_NULL = "\u0000";
    public static final String MECHANISM_NAME = "PLAIN";
    private final UserAuthenticator authenticator;
    private boolean completed = false;
    private String authorizationID;

    PlainServer(UserAuthenticator authenticator, Map<String, ?> properties) throws SaslException {
        if (properties != null && "true".equalsIgnoreCase((String)properties.get("javax.security.sasl.policy.noplaintext"))) {
            throw new SaslException("PLAIN authentication is not permitted.");
        }
        this.authenticator = authenticator;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM_NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        if (response == null) {
            throw new SaslException("Received null response");
        }
        String payload = new String(response, StandardCharsets.UTF_8);
        String[] parts = payload.split(UTF_8_NULL, 3);
        if (parts.length != 3) {
            throw new SaslException("Received corrupt response. Expected 3 parts, but received " + parts.length);
        }
        String authorizationID = parts[0];
        String authenticationID = parts[1];
        String password = parts[2];
        if (authorizationID.isEmpty()) {
            authorizationID = authenticationID;
        }
        try {
            this.authenticator.authenticate(authenticationID, password);
        }
        catch (UserAuthenticationException e) {
            throw new SaslException(e.getMessage());
        }
        if (!authorizationID.equals(authenticationID)) {
            throw new SaslException("Drill expects authorization ID and authentication ID to match. Use inbound impersonation feature so one entity can act on behalf of another.");
        }
        this.authorizationID = authorizationID;
        this.completed = true;
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authorizationID;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            return "javax.security.sasl.qop".equals(propName) ? "auth" : null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public void dispose() throws SaslException {
        this.authorizationID = null;
    }
}

