/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.util.Map;
import java.util.Set;
import javax.security.sasl.SaslException;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorProvider;
import oadd.org.apache.drill.exec.rpc.security.kerberos.KerberosFactory;
import oadd.org.apache.drill.exec.rpc.security.plain.PlainFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthenticatorProvider
implements AuthenticatorProvider {
    private static final Logger logger = LoggerFactory.getLogger(ClientAuthenticatorProvider.class);
    private static final String customFactories = System.getProperty("drill.customAuthFactories");
    private final Map<String, AuthenticatorFactory> authFactories = CaseInsensitiveMap.newHashMapWithExpectedSize(5);

    public static ClientAuthenticatorProvider getInstance() {
        return Holder.INSTANCE;
    }

    private ClientAuthenticatorProvider() {
        KerberosFactory kerberosFactory = new KerberosFactory();
        this.authFactories.put(kerberosFactory.getSimpleName(), kerberosFactory);
        PlainFactory plainFactory = new PlainFactory();
        this.authFactories.put(plainFactory.getSimpleName(), plainFactory);
        if (customFactories != null) {
            String[] factories;
            for (String factory : factories = customFactories.split(",")) {
                try {
                    Class<?> clazz = Class.forName(factory);
                    if (!AuthenticatorFactory.class.isAssignableFrom(clazz)) continue;
                    AuthenticatorFactory instance = (AuthenticatorFactory)clazz.newInstance();
                    this.authFactories.put(instance.getSimpleName(), instance);
                }
                catch (ReflectiveOperationException e) {
                    logger.error("Failed to create auth factory {}", (Object)factory, (Object)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Configured mechanisms: {}", (Object)this.authFactories.keySet());
        }
    }

    @Override
    public AuthenticatorFactory getAuthenticatorFactory(String name) throws SaslException {
        AuthenticatorFactory mechanism = this.authFactories.get(name);
        if (mechanism == null) {
            throw new SaslException(String.format("Unknown mechanism: '%s' Configured mechanisms: %s", name, this.authFactories.keySet()));
        }
        return mechanism;
    }

    @Override
    public Set<String> getAllFactoryNames() {
        return this.authFactories.keySet();
    }

    @Override
    public boolean containsFactory(String name) {
        return this.authFactories.containsKey(name);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.authFactories.values());
        this.authFactories.clear();
    }

    private static final class Holder {
        static final ClientAuthenticatorProvider INSTANCE = new ClientAuthenticatorProvider();

        private Holder() {
        }
    }
}

