/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.List;
import oadd.com.google.protobuf.CodedInputStream;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.ByteToMessageDecoder;
import oadd.io.netty.handler.codec.CorruptedFrameException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufLengthDecoder
extends ByteToMessageDecoder {
    static final Logger logger = LoggerFactory.getLogger(ProtobufLengthDecoder.class);
    private BufferAllocator allocator;
    private OutOfMemoryHandler outOfMemoryHandler;

    public ProtobufLengthDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        this.allocator = allocator;
        this.outOfMemoryHandler = outOfMemoryHandler;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isOpen()) {
            if (in.readableBytes() > 0) {
                logger.info("Channel is closed, discarding remaining {} byte(s) in buffer.", (Object)in.readableBytes());
            }
            in.skipBytes(in.readableBytes());
            return;
        }
        in.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            DrillBuf outBuf;
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance(buf, 0, i + 1).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (length == 0) {
                throw new CorruptedFrameException("Received a message of length 0.");
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            try {
                outBuf = this.allocator.buffer(length);
            }
            catch (OutOfMemoryException e) {
                logger.warn("Failure allocating buffer on incoming stream due to memory limits.  Current Allocation: {}.", (Object)this.allocator.getAllocatedMemory());
                in.resetReaderIndex();
                this.outOfMemoryHandler.handle();
                return;
            }
            ((ByteBuf)outBuf).writeBytes(in, in.readerIndex(), length);
            in.skipBytes(length);
            out.add(outBuf);
            return;
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }
}

