/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class DynamicSemaphore {
    private static final int INITIAL_STATIC_CREDIT = 3;
    private final Semaphore semaphore = new Semaphore(3);
    private final AtomicBoolean changed = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    private int firstReceivedCredit = -1;

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public void release() {
        this.semaphore.release();
    }

    public void tryToIncreaseCredit(int suggestedSemaphoreVal) {
        if (suggestedSemaphoreVal < 3) {
            return;
        }
        if (this.changed.get()) {
            return;
        }
        try {
            this.lock.lock();
            if (suggestedSemaphoreVal <= this.firstReceivedCredit) {
                return;
            }
            this.firstReceivedCredit = suggestedSemaphoreVal;
            int increasedSemaphoreNumber = suggestedSemaphoreVal - 3;
            this.semaphore.release(increasedSemaphoreNumber);
            this.changed.compareAndSet(false, true);
        }
        finally {
            this.lock.unlock();
        }
    }
}

