/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata.schema.parser;

import java.io.IOException;
import oadd.org.antlr.v4.runtime.BaseErrorListener;
import oadd.org.antlr.v4.runtime.CharStreams;
import oadd.org.antlr.v4.runtime.CodePointCharStream;
import oadd.org.antlr.v4.runtime.CommonTokenStream;
import oadd.org.antlr.v4.runtime.RecognitionException;
import oadd.org.antlr.v4.runtime.Recognizer;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaLexer;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaParser;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaParsingException;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaVisitor;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.UpperCaseCharStream;

public class SchemaExprParser {
    public static TupleMetadata parseSchema(String schema) throws IOException {
        SchemaVisitor visitor = new SchemaVisitor();
        try {
            return (TupleMetadata)visitor.visit(SchemaExprParser.initParser(schema).schema());
        }
        catch (SchemaParsingException e) {
            throw new IOException(String.format("Unable to parse schema [%s]: %s", schema, e.getMessage()), e);
        }
    }

    public static ColumnMetadata parseColumn(String name, String type, TypeProtos.DataMode mode) throws IOException {
        return SchemaExprParser.parseColumn(String.format("`%s` %s %s", name.replaceAll("(\\\\)|(`)", "\\\\$0"), type, TypeProtos.DataMode.REQUIRED == mode ? "not null" : ""));
    }

    public static ColumnMetadata parseColumn(String column) throws IOException {
        SchemaVisitor.ColumnVisitor visitor = new SchemaVisitor.ColumnVisitor();
        try {
            return (ColumnMetadata)visitor.visit(SchemaExprParser.initParser(column).column());
        }
        catch (SchemaParsingException e) {
            throw new IOException(String.format("Unable to parse column [%s]: %s", column, e.getMessage()), e);
        }
    }

    private static SchemaParser initParser(String value) {
        CodePointCharStream stream = CharStreams.fromString(value);
        UpperCaseCharStream upperCaseStream = new UpperCaseCharStream(stream);
        SchemaLexer lexer = new SchemaLexer(upperCaseStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener(ErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        SchemaParser parser = new SchemaParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(ErrorListener.INSTANCE);
        return parser;
    }

    private static class ErrorListener
    extends BaseErrorListener {
        static final ErrorListener INSTANCE = new ErrorListener();

        private ErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("Line [").append(line).append("]");
            builder.append(", position [").append(charPositionInLine).append("]");
            if (offendingSymbol != null) {
                builder.append(", offending symbol ").append(offendingSymbol);
            }
            if (msg != null) {
                builder.append(": ").append(msg);
            }
            throw new SchemaParsingException(builder.toString());
        }
    }
}

