/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.drill.exec.ops.MetricDef;
import oadd.org.apache.drill.exec.physical.impl.ScreenCreator;
import oadd.org.apache.drill.exec.physical.impl.SingleSenderCreator;
import oadd.org.apache.drill.exec.physical.impl.aggregate.HashAggTemplate;
import oadd.org.apache.drill.exec.physical.impl.broadcastsender.BroadcastSenderRootExec;
import oadd.org.apache.drill.exec.physical.impl.filter.RuntimeFilterRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.flatten.FlattenRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.join.HashJoinBatch;
import oadd.org.apache.drill.exec.physical.impl.mergereceiver.MergingRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.partitionsender.PartitionSenderRootExec;
import oadd.org.apache.drill.exec.physical.impl.unnest.UnnestRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.unorderedreceiver.UnorderedReceiverBatch;
import oadd.org.apache.drill.exec.physical.impl.xsort.ExternalSortBatch;
import oadd.org.apache.drill.exec.record.AbstractBinaryRecordBatch;
import oadd.org.apache.drill.exec.store.CommonParquetRecordReader;

public class OperatorMetricRegistry {
    private static final Map<String, String[]> OPERATOR_METRICS = new HashMap<String, String[]>();

    private static void register(String operatorType, Class<? extends MetricDef> metricDef) {
        MetricDef[] enumConstants = metricDef.getEnumConstants();
        if (enumConstants != null) {
            String[] names = (String[])Arrays.stream(enumConstants).map(MetricDef::name).toArray(String[]::new);
            OPERATOR_METRICS.put(operatorType, names);
        }
    }

    public static String[] getMetricNames(String operatorType) {
        return OPERATOR_METRICS.get(operatorType);
    }

    private OperatorMetricRegistry() {
    }

    static {
        OperatorMetricRegistry.register("SCREEN", ScreenCreator.ScreenRoot.Metric.class);
        OperatorMetricRegistry.register("SINGLE_SENDER", SingleSenderCreator.SingleSenderRootExec.Metric.class);
        OperatorMetricRegistry.register("BROADCAST_SENDER", BroadcastSenderRootExec.Metric.class);
        OperatorMetricRegistry.register("HASH_PARTITION_SENDER", PartitionSenderRootExec.Metric.class);
        OperatorMetricRegistry.register("MERGING_RECEIVER", MergingRecordBatch.Metric.class);
        OperatorMetricRegistry.register("UNORDERED_RECEIVER", UnorderedReceiverBatch.Metric.class);
        OperatorMetricRegistry.register("HASH_AGGREGATE", HashAggTemplate.Metric.class);
        OperatorMetricRegistry.register("HASH_JOIN", HashJoinBatch.Metric.class);
        OperatorMetricRegistry.register("EXTERNAL_SORT", ExternalSortBatch.Metric.class);
        OperatorMetricRegistry.register("PARQUET_ROW_GROUP_SCAN", CommonParquetRecordReader.Metric.class);
        OperatorMetricRegistry.register("FLATTEN", FlattenRecordBatch.Metric.class);
        OperatorMetricRegistry.register("MERGE_JOIN", AbstractBinaryRecordBatch.Metric.class);
        OperatorMetricRegistry.register("LATERAL_JOIN", AbstractBinaryRecordBatch.Metric.class);
        OperatorMetricRegistry.register("UNNEST", UnnestRecordBatch.Metric.class);
        OperatorMetricRegistry.register("UNION", AbstractBinaryRecordBatch.Metric.class);
        OperatorMetricRegistry.register("RUNTIME_FILTER", RuntimeFilterRecordBatch.Metric.class);
    }
}

