/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiFunction;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.FilterPredicate;
import oadd.org.apache.drill.exec.expr.IsPredicate;
import oadd.org.apache.drill.exec.expr.StatisticsProvider;
import oadd.org.apache.drill.exec.expr.stat.RowsMatch;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;

public class ComparisonPredicate<C extends Comparable<C>>
extends LogicalExpressionBase
implements FilterPredicate<C> {
    private final LogicalExpression left;
    private final LogicalExpression right;
    private final BiFunction<ColumnStatistics<C>, ColumnStatistics<C>, RowsMatch> predicate;

    private ComparisonPredicate(LogicalExpression left, LogicalExpression right, BiFunction<ColumnStatistics<C>, ColumnStatistics<C>, RowsMatch> predicate) {
        super(left.getPosition());
        this.left = left;
        this.right = right;
        this.predicate = predicate;
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        args.add(this.left);
        args.add(this.right);
        return args.iterator();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitUnknown(this, value);
    }

    @Override
    public RowsMatch matches(StatisticsProvider<C> evaluator) {
        ColumnStatistics<BigInteger> leftStat = (ColumnStatistics<BigInteger>)this.left.accept(evaluator, null);
        if (IsPredicate.isNullOrEmpty(leftStat)) {
            return RowsMatch.SOME;
        }
        ColumnStatistics<BigInteger> rightStat = (ColumnStatistics<BigInteger>)this.right.accept(evaluator, null);
        if (IsPredicate.isNullOrEmpty(rightStat)) {
            return RowsMatch.SOME;
        }
        if (IsPredicate.isAllNulls(leftStat, evaluator.getRowCount()) || IsPredicate.isAllNulls(rightStat, evaluator.getRowCount())) {
            return RowsMatch.NONE;
        }
        if (!IsPredicate.hasNonNullValues(leftStat, evaluator.getRowCount()) || !IsPredicate.hasNonNullValues(rightStat, evaluator.getRowCount())) {
            return RowsMatch.SOME;
        }
        if (this.left.getMajorType().getMinorType() == TypeProtos.MinorType.VARDECIMAL) {
            int rightScale;
            int leftScale = this.left.getMajorType().getScale();
            if (leftScale > (rightScale = this.right.getMajorType().getScale())) {
                rightStat = this.adjustDecimalStatistics(rightStat, leftScale - rightScale);
            } else if (leftScale < rightScale) {
                leftStat = this.adjustDecimalStatistics(leftStat, rightScale - leftScale);
            }
        }
        return this.predicate.apply(leftStat, rightStat);
    }

    private ColumnStatistics<BigInteger> adjustDecimalStatistics(ColumnStatistics<BigInteger> statistics, int scale) {
        BigInteger min2 = new BigDecimal((BigInteger)ColumnStatisticsKind.MIN_VALUE.getValueStatistic(statistics)).setScale(scale, RoundingMode.HALF_UP).unscaledValue();
        BigInteger max = new BigDecimal((BigInteger)ColumnStatisticsKind.MAX_VALUE.getValueStatistic(statistics)).setScale(scale, RoundingMode.HALF_UP).unscaledValue();
        return StatisticsProvider.getColumnStatistics(min2, max, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(statistics), TypeProtos.MinorType.VARDECIMAL);
    }

    private static RowsMatch checkNull(ColumnStatistics<?> leftStat, ColumnStatistics<?> rightStat) {
        return !IsPredicate.hasNoNulls(leftStat) || !IsPredicate.hasNoNulls(rightStat) ? RowsMatch.SOME : RowsMatch.ALL;
    }

    private static <C extends Comparable<C>> LogicalExpression createEqualPredicate(final LogicalExpression left, final LogicalExpression right) {
        return new ComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparator valueComparator = leftStat.getValueComparator();
            int leftToRightComparison = valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMinValue(rightStat));
            int rightToLeftComparison = valueComparator.compare(ComparisonPredicate.getMaxValue(rightStat), ComparisonPredicate.getMinValue(leftStat));
            if (leftToRightComparison == 0 && rightToLeftComparison == 0 && IsPredicate.hasNoNulls(leftStat) && IsPredicate.hasNoNulls(rightStat)) {
                return RowsMatch.ALL;
            }
            return leftToRightComparison < 0 || rightToLeftComparison < 0 ? RowsMatch.NONE : RowsMatch.SOME;
        }){

            public String toString() {
                return left + " = " + right;
            }
        };
    }

    private static <C extends Comparable<C>> LogicalExpression createGTPredicate(LogicalExpression left, LogicalExpression right) {
        return new ComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparator valueComparator = leftStat.getValueComparator();
            if (valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMinValue(rightStat)) <= 0) {
                return RowsMatch.NONE;
            }
            return valueComparator.compare(ComparisonPredicate.getMinValue(leftStat), ComparisonPredicate.getMaxValue(rightStat)) > 0 ? ComparisonPredicate.checkNull(leftStat, rightStat) : RowsMatch.SOME;
        });
    }

    static <C> C getMaxValue(ColumnStatistics<C> leftStat) {
        return (C)ColumnStatisticsKind.MAX_VALUE.getValueStatistic(leftStat);
    }

    static <C> C getMinValue(ColumnStatistics<C> leftStat) {
        return (C)ColumnStatisticsKind.MIN_VALUE.getValueStatistic(leftStat);
    }

    private static <C extends Comparable<C>> LogicalExpression createGEPredicate(LogicalExpression left, LogicalExpression right) {
        return new ComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparator valueComparator = leftStat.getValueComparator();
            if (valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMinValue(rightStat)) < 0) {
                return RowsMatch.NONE;
            }
            return valueComparator.compare(ComparisonPredicate.getMinValue(leftStat), ComparisonPredicate.getMaxValue(rightStat)) >= 0 ? ComparisonPredicate.checkNull(leftStat, rightStat) : RowsMatch.SOME;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createLTPredicate(LogicalExpression left, LogicalExpression right) {
        return new ComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparator valueComparator = leftStat.getValueComparator();
            if (valueComparator.compare(ComparisonPredicate.getMaxValue(rightStat), ComparisonPredicate.getMinValue(leftStat)) <= 0) {
                return RowsMatch.NONE;
            }
            return valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMinValue(rightStat)) < 0 ? ComparisonPredicate.checkNull(leftStat, rightStat) : RowsMatch.SOME;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createLEPredicate(LogicalExpression left, LogicalExpression right) {
        return new ComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparator valueComparator = leftStat.getValueComparator();
            if (valueComparator.compare(ComparisonPredicate.getMaxValue(rightStat), ComparisonPredicate.getMinValue(leftStat)) < 0) {
                return RowsMatch.NONE;
            }
            return valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMinValue(rightStat)) <= 0 ? ComparisonPredicate.checkNull(leftStat, rightStat) : RowsMatch.SOME;
        });
    }

    private static <C extends Comparable<C>> LogicalExpression createNEPredicate(LogicalExpression left, LogicalExpression right) {
        return new ComparisonPredicate<C>(left, right, (leftStat, rightStat) -> {
            Comparator valueComparator = leftStat.getValueComparator();
            if (valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMinValue(rightStat)) < 0 || valueComparator.compare(ComparisonPredicate.getMaxValue(rightStat), ComparisonPredicate.getMinValue(leftStat)) < 0) {
                return ComparisonPredicate.checkNull(leftStat, rightStat);
            }
            return valueComparator.compare(ComparisonPredicate.getMaxValue(leftStat), ComparisonPredicate.getMaxValue(rightStat)) == 0 && valueComparator.compare(ComparisonPredicate.getMinValue(leftStat), ComparisonPredicate.getMinValue(rightStat)) == 0 ? RowsMatch.NONE : RowsMatch.SOME;
        });
    }

    public static <C extends Comparable<C>> LogicalExpression createComparisonPredicate(String function, LogicalExpression left, LogicalExpression right) {
        switch (function) {
            case "equal": {
                return ComparisonPredicate.createEqualPredicate(left, right);
            }
            case "greater_than": {
                return ComparisonPredicate.createGTPredicate(left, right);
            }
            case "greater_than_or_equal_to": {
                return ComparisonPredicate.createGEPredicate(left, right);
            }
            case "less_than": {
                return ComparisonPredicate.createLTPredicate(left, right);
            }
            case "less_than_or_equal_to": {
                return ComparisonPredicate.createLEPredicate(left, right);
            }
            case "not_equal": {
                return ComparisonPredicate.createNEPredicate(left, right);
            }
        }
        return null;
    }
}

