/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.ArrayList;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.exec.expr.DrillFuncHolderExpr;
import oadd.org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class CloneVisitor
extends AbstractExprVisitor<LogicalExpression, Void, RuntimeException> {
    @Override
    public LogicalExpression visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (LogicalExpression arg : call.args()) {
            args.add(arg.accept(this, null));
        }
        return new FunctionCall(call.getName(), args, call.getPosition());
    }

    @Override
    public LogicalExpression visitFunctionHolderExpression(FunctionHolderExpression holder, Void value) throws RuntimeException {
        if (holder instanceof DrillFuncHolderExpr) {
            ArrayList<LogicalExpression> args = Lists.newArrayList();
            for (LogicalExpression arg : holder.args) {
                args.add(arg.accept(this, null));
            }
            return new DrillFuncHolderExpr(holder.getName(), (DrillFuncHolder)holder.getHolder(), args, holder.getPosition());
        }
        return null;
    }

    @Override
    public LogicalExpression visitIfExpression(IfExpression ifExpr, Void value) throws RuntimeException {
        LogicalExpression ifCondition = ifExpr.ifCondition.condition.accept(this, null);
        LogicalExpression ifExpression = ifExpr.ifCondition.expression.accept(this, null);
        LogicalExpression elseExpression = ifExpr.elseExpression.accept(this, null);
        IfExpression.IfCondition condition = new IfExpression.IfCondition(ifCondition, ifExpression);
        return IfExpression.newBuilder().setIfCondition(condition).setElse(elseExpression).build();
    }

    @Override
    public LogicalExpression visitBooleanOperator(BooleanOperator op, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)op, value);
    }

    @Override
    public LogicalExpression visitSchemaPath(SchemaPath path, Void value) throws RuntimeException {
        return path;
    }

    @Override
    public LogicalExpression visitFloatConstant(ValueExpressions.FloatExpression fExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)fExpr, value);
    }

    @Override
    public LogicalExpression visitIntConstant(ValueExpressions.IntExpression intExpr, Void value) throws RuntimeException {
        return new ValueExpressions.IntExpression(intExpr.getInt(), intExpr.getPosition());
    }

    @Override
    public LogicalExpression visitLongConstant(ValueExpressions.LongExpression intExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)intExpr, value);
    }

    @Override
    public LogicalExpression visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)decExpr, value);
    }

    @Override
    public LogicalExpression visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)decExpr, value);
    }

    @Override
    public LogicalExpression visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)decExpr, value);
    }

    @Override
    public LogicalExpression visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)decExpr, value);
    }

    @Override
    public LogicalExpression visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)decExpr, value);
    }

    @Override
    public LogicalExpression visitDateConstant(ValueExpressions.DateExpression intExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)intExpr, value);
    }

    @Override
    public LogicalExpression visitTimeConstant(ValueExpressions.TimeExpression intExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)intExpr, value);
    }

    @Override
    public LogicalExpression visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)intExpr, value);
    }

    @Override
    public LogicalExpression visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)intExpr, value);
    }

    @Override
    public LogicalExpression visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)intExpr, value);
    }

    @Override
    public LogicalExpression visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)dExpr, value);
    }

    @Override
    public LogicalExpression visitBooleanConstant(ValueExpressions.BooleanExpression e, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public LogicalExpression visitQuotedStringConstant(ValueExpressions.QuotedString e, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public LogicalExpression visitCastExpression(CastExpression e, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public LogicalExpression visitConvertExpression(ConvertExpression e, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public LogicalExpression visitNullConstant(TypedNullConstant e, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public LogicalExpression visitNullExpression(NullExpression e, Void value) throws RuntimeException {
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public LogicalExpression visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        return e;
    }
}

