/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.exception;

import oadd.org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import oadd.org.apache.drill.exec.work.foreman.UnsupportedDataTypeException;
import oadd.org.apache.drill.exec.work.foreman.UnsupportedFunctionException;
import oadd.org.apache.drill.exec.work.foreman.UnsupportedRelOperatorException;

public class UnsupportedOperatorCollector {
    private SqlUnsupportedException.ExceptionType exceptionType = SqlUnsupportedException.ExceptionType.NONE;
    private String message;

    public boolean convertException() throws SqlUnsupportedException {
        switch (this.exceptionType) {
            case RELATIONAL: {
                this.clean();
                throw new UnsupportedRelOperatorException(this.message);
            }
            case DATA_TYPE: {
                this.clean();
                throw new UnsupportedDataTypeException(this.message);
            }
            case FUNCTION: {
                this.clean();
                throw new UnsupportedFunctionException(this.message);
            }
        }
        return false;
    }

    public void setException(SqlUnsupportedException.ExceptionType exceptionType, String message) {
        if (this.exceptionType != SqlUnsupportedException.ExceptionType.NONE) {
            throw new IllegalStateException("Exception was set already");
        }
        this.exceptionType = exceptionType;
        this.message = message;
    }

    public void setException(SqlUnsupportedException.ExceptionType exceptionType) {
        this.setException(exceptionType, "");
    }

    public void clean() {
        this.exceptionType = SqlUnsupportedException.ExceptionType.NONE;
    }
}

