/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.exception;

import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;

public class MetadataException
extends DrillRuntimeException {
    private final MetadataExceptionType exceptionType;

    private MetadataException(MetadataExceptionType exceptionType) {
        super(exceptionType.message);
        this.exceptionType = exceptionType;
    }

    private MetadataException(MetadataExceptionType exceptionType, Throwable cause) {
        super(exceptionType.message, cause);
        this.exceptionType = exceptionType;
    }

    public MetadataExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public static MetadataException of(MetadataExceptionType exceptionType) {
        return new MetadataException(exceptionType);
    }

    public static MetadataException of(MetadataExceptionType exceptionType, Throwable cause) {
        return new MetadataException(exceptionType, cause);
    }

    public static enum MetadataExceptionType {
        OUTDATED_METADATA("Metastore metadata is outdated."),
        INCONSISTENT_METADATA("Inconsistent Metastore metadata. Metadata was refreshed after it was fetched from the Metastore."),
        INCOMPLETE_METADATA("Metastore does not have metadata for row groups and `metastore.metadata.fallback_to_file_metadata` is disabled. Please either execute ANALYZE with 'ROW_GROUP' level for the querying table or enable `metastore.metadata.fallback_to_file_metadata` to allow using metadata taken from the file metadata cache or table files."),
        ABSENT_SCHEMA("Table schema wasn't provided and `metastore.metadata.use_schema` is disabled. Please either provide table schema for [%s] table (using table function or creating schema file) or enable `metastore.metadata.use_schema`."),
        FALLBACK_EXCEPTION("Exception happened when was attempting to use fallback metadata.");

        private final String message;

        private MetadataExceptionType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

