/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical.data;

import java.util.List;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.org.apache.drill.common.exceptions.ExpressionParsingException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.logical.data.AbstractSingleBuilder;
import oadd.org.apache.drill.common.logical.data.NamedExpression;
import oadd.org.apache.drill.common.logical.data.SingleInputOperator;
import oadd.org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="project")
public class Project
extends SingleInputOperator {
    private final List<NamedExpression> selections;

    @JsonCreator
    public Project(@JsonProperty(value="projections") List<NamedExpression> selections) {
        this.selections = selections;
        if (selections == null || selections.size() == 0) {
            throw new ExpressionParsingException("Project did not provide any projection selections.  At least one projection must be provided.");
        }
    }

    @JsonProperty(value="projections")
    public List<NamedExpression> getSelections() {
        return this.selections;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitProject(this, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSingleBuilder<Project, Builder> {
        private List<NamedExpression> exprs = Lists.newArrayList();

        public Builder addExpr(NamedExpression expr) {
            this.exprs.add(expr);
            return this;
        }

        public Builder addExpr(FieldReference ref, LogicalExpression expr) {
            this.exprs.add(new NamedExpression(expr, ref));
            return this;
        }

        @Override
        public Project internalBuild() {
            return new Project(this.exprs);
        }
    }
}

