/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework.recipes.nodes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import oadd.org.apache.curator.framework.recipes.nodes.PersistentNode;
import oadd.org.apache.curator.utils.ThreadUtils;
import oadd.org.apache.curator.utils.ZKPaths;
import oadd.org.apache.zookeeper.CreateMode;
import oadd.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTtlNode
implements Closeable {
    public static final String DEFAULT_CHILD_NODE_NAME = "touch";
    public static final int DEFAULT_TOUCH_SCHEDULE_FACTOR = 2;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PersistentNode node;
    private final CuratorFramework client;
    private final long ttlMs;
    private final int touchScheduleFactor;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<Future<?>> futureRef = new AtomicReference();
    private final String childPath;

    public PersistentTtlNode(CuratorFramework client, String path, long ttlMs, byte[] initData) {
        this(client, Executors.newSingleThreadScheduledExecutor(ThreadUtils.newThreadFactory("PersistentTtlNode")), path, ttlMs, initData, DEFAULT_CHILD_NODE_NAME, 2);
    }

    public PersistentTtlNode(CuratorFramework client, ScheduledExecutorService executorService, String path, long ttlMs, byte[] initData, String childNodeName, int touchScheduleFactor) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.ttlMs = ttlMs;
        this.touchScheduleFactor = touchScheduleFactor;
        this.node = new PersistentNode(client, CreateMode.CONTAINER, false, path, initData){

            @Override
            protected void deleteNode() {
            }
        };
        this.executorService = Objects.requireNonNull(executorService, "executorService cannot be null");
        this.childPath = ZKPaths.makePath(Objects.requireNonNull(path, "path cannot be null"), childNodeName);
    }

    public void start() {
        this.node.start();
        Runnable touchTask = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        try {
                            PersistentTtlNode.this.client.setData().forPath(PersistentTtlNode.this.childPath);
                        }
                        catch (KeeperException.NoNodeException e) {
                            ((ACLBackgroundPathAndBytesable)PersistentTtlNode.this.client.create().orSetData().withTtl(PersistentTtlNode.this.ttlMs).withMode(CreateMode.PERSISTENT_WITH_TTL)).forPath(PersistentTtlNode.this.childPath);
                        }
                    }
                    catch (KeeperException.NoNodeException e) {
                    }
                    catch (Exception e) {
                        if (ThreadUtils.checkInterrupted(e)) break block5;
                        PersistentTtlNode.this.log.debug("Could not touch child node", e);
                    }
                }
            }
        };
        ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(touchTask, this.ttlMs / (long)this.touchScheduleFactor, this.ttlMs / (long)this.touchScheduleFactor, TimeUnit.MILLISECONDS);
        this.futureRef.set(future);
    }

    public boolean waitForInitialCreate(long timeout, TimeUnit unit) throws InterruptedException {
        return this.node.waitForInitialCreate(timeout, unit);
    }

    public void setData(byte[] data) throws Exception {
        this.node.setData(data);
    }

    public byte[] getData() {
        return this.node.getData();
    }

    @Override
    public void close() {
        Future future = this.futureRef.getAndSet(null);
        if (future != null) {
            future.cancel(true);
        }
        try {
            this.node.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

