/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework.imps;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import oadd.org.apache.curator.RetryLoop;
import oadd.org.apache.curator.drivers.OperationTrace;
import oadd.org.apache.curator.framework.api.ACLableExistBuilderMain;
import oadd.org.apache.curator.framework.api.BackgroundCallback;
import oadd.org.apache.curator.framework.api.BackgroundPathable;
import oadd.org.apache.curator.framework.api.CuratorEventType;
import oadd.org.apache.curator.framework.api.CuratorWatcher;
import oadd.org.apache.curator.framework.api.ErrorListenerPathable;
import oadd.org.apache.curator.framework.api.ExistsBuilder;
import oadd.org.apache.curator.framework.api.ExistsBuilderMain;
import oadd.org.apache.curator.framework.api.Pathable;
import oadd.org.apache.curator.framework.api.UnhandledErrorListener;
import oadd.org.apache.curator.framework.imps.ACLing;
import oadd.org.apache.curator.framework.imps.BackgroundOperation;
import oadd.org.apache.curator.framework.imps.Backgrounding;
import oadd.org.apache.curator.framework.imps.CreateBuilderImpl;
import oadd.org.apache.curator.framework.imps.CuratorEventImpl;
import oadd.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import oadd.org.apache.curator.framework.imps.OperationAndData;
import oadd.org.apache.curator.framework.imps.Watching;
import oadd.org.apache.curator.utils.ZKPaths;
import oadd.org.apache.zookeeper.AsyncCallback;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.data.ACL;
import oadd.org.apache.zookeeper.data.Stat;

public class ExistsBuilderImpl
implements ExistsBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Stat>,
ACLableExistBuilderMain {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Watching watching;
    private boolean createParentsIfNeeded;
    private boolean createParentContainersIfNeeded;
    private ACLing acling;

    ExistsBuilderImpl(CuratorFrameworkImpl client) {
        this(client, new Backgrounding(), null, false, false);
    }

    public ExistsBuilderImpl(CuratorFrameworkImpl client, Backgrounding backgrounding, Watcher watcher, boolean createParentsIfNeeded, boolean createParentContainersIfNeeded) {
        this.client = client;
        this.backgrounding = backgrounding;
        this.watching = new Watching(client, watcher);
        this.createParentsIfNeeded = createParentsIfNeeded;
        this.createParentContainersIfNeeded = createParentContainersIfNeeded;
        this.acling = new ACLing(client.getAclProvider());
    }

    @Override
    public ACLableExistBuilderMain creatingParentsIfNeeded() {
        this.createParentContainersIfNeeded = false;
        this.createParentsIfNeeded = true;
        return this;
    }

    @Override
    public ACLableExistBuilderMain creatingParentContainersIfNeeded() {
        this.createParentContainersIfNeeded = true;
        this.createParentsIfNeeded = false;
        return this;
    }

    @Override
    public ExistsBuilderMain withACL(List<ACL> aclList) {
        this.acling = new ACLing(this.client.getAclProvider(), aclList, true);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> watched() {
        this.watching = new Watching(this.client, true);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Background");
            AsyncCallback.StatCallback callback = new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ExistsBuilderImpl.this.watching.commitWatcher(rc, true);
                    trace.setReturnCode(rc).setPath(path).setWithWatcher(ExistsBuilderImpl.this.watching.hasWatcher()).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(ExistsBuilderImpl.this.client, CuratorEventType.EXISTS, rc, path, null, ctx, stat, null, null, null, null, null);
                    ExistsBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            if (this.watching.isWatched()) {
                this.client.getZooKeeper().exists(operationAndData.getData(), true, callback, this.backgrounding.getContext());
            } else {
                this.client.getZooKeeper().exists(operationAndData.getData(), this.watching.getWatcher(operationAndData.getData()), callback, this.backgrounding.getContext());
            }
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, this.watching);
        }
    }

    @Override
    public Stat forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        this.client.getSchemaSet().getSchema(path).validateWatch(path, this.watching.isWatched() || this.watching.hasWatcher());
        Stat returnStat = null;
        if (this.backgrounding.inBackground()) {
            OperationAndData<String> operationAndData = new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), this.watching);
            if (this.createParentContainersIfNeeded || this.createParentsIfNeeded) {
                CreateBuilderImpl.backgroundCreateParentsThenNode(this.client, operationAndData, operationAndData.getData(), this.backgrounding, this.acling.getACLProviderForParents(), this.createParentContainersIfNeeded);
            } else {
                this.client.processBackgroundOperation(operationAndData, null);
            }
        } else {
            returnStat = this.pathInForeground(path);
        }
        return returnStat;
    }

    private Stat pathInForeground(String path) throws Exception {
        String parent;
        if ((this.createParentContainersIfNeeded || this.createParentsIfNeeded) && !(parent = ZKPaths.getPathAndNode(path).getPath()).equals("/")) {
            OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Foreground-CreateParents");
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        ZKPaths.mkdirs(ExistsBuilderImpl.this.client.getZooKeeper(), parent, true, ExistsBuilderImpl.this.acling.getACLProviderForParents(), ExistsBuilderImpl.this.createParentContainersIfNeeded);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            trace.setPath(path).commit();
        }
        return this.pathInForegroundStandard(path);
    }

    private Stat pathInForegroundStandard(final String path) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Foreground");
        Stat returnStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                Stat returnStat;
                if (ExistsBuilderImpl.this.watching.isWatched()) {
                    returnStat = ExistsBuilderImpl.this.client.getZooKeeper().exists(path, true);
                } else {
                    returnStat = ExistsBuilderImpl.this.client.getZooKeeper().exists(path, ExistsBuilderImpl.this.watching.getWatcher(path));
                    int rc = returnStat != null ? KeeperException.Code.OK.intValue() : KeeperException.Code.NONODE.intValue();
                    ExistsBuilderImpl.this.watching.commitWatcher(rc, true);
                }
                return returnStat;
            }
        });
        trace.setPath(path).setWithWatcher(this.watching.hasWatcher()).setStat(returnStat).commit();
        return returnStat;
    }
}

