/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.transform;

import oadd.org.apache.commons.math.FunctionEvaluationException;
import oadd.org.apache.commons.math.MathRuntimeException;
import oadd.org.apache.commons.math.analysis.UnivariateRealFunction;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.transform.FastFourierTransformer;
import oadd.org.apache.commons.math.transform.RealTransformer;

public class FastHadamardTransformer
implements RealTransformer {
    public double[] transform(double[] f) throws IllegalArgumentException {
        return this.fht(f);
    }

    public double[] transform(UnivariateRealFunction f, double min2, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        return this.fht(FastFourierTransformer.sample(f, min2, max, n));
    }

    public double[] inversetransform(double[] f) throws IllegalArgumentException {
        return FastFourierTransformer.scaleArray(this.fht(f), 1.0 / (double)f.length);
    }

    public double[] inversetransform(UnivariateRealFunction f, double min2, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] unscaled = this.fht(FastFourierTransformer.sample(f, min2, max, n));
        return FastFourierTransformer.scaleArray(unscaled, 1.0 / (double)n);
    }

    public int[] transform(int[] f) throws IllegalArgumentException {
        return this.fht(f);
    }

    protected double[] fht(double[] x) throws IllegalArgumentException {
        int n = x.length;
        int halfN = n / 2;
        if (!FastFourierTransformer.isPowerOf2(n)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        double[] yPrevious = new double[n];
        double[] yCurrent = (double[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            double[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }

    protected int[] fht(int[] x) throws IllegalArgumentException {
        int n = x.length;
        int halfN = n / 2;
        if (!FastFourierTransformer.isPowerOf2(n)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        int[] yPrevious = new int[n];
        int[] yCurrent = (int[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            int[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }
}

