/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import oadd.org.apache.calcite.avatica.AvaticaClientRuntimeException;
import oadd.org.apache.calcite.avatica.AvaticaFactory;
import oadd.org.apache.calcite.avatica.AvaticaPreparedStatement;
import oadd.org.apache.calcite.avatica.AvaticaResultSet;
import oadd.org.apache.calcite.avatica.AvaticaSpecificDatabaseMetaData;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.AvaticaUtils;
import oadd.org.apache.calcite.avatica.ColumnMetaData;
import oadd.org.apache.calcite.avatica.ConnectionConfig;
import oadd.org.apache.calcite.avatica.ConnectionConfigImpl;
import oadd.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import oadd.org.apache.calcite.avatica.Helper;
import oadd.org.apache.calcite.avatica.InternalProperty;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.NoSuchStatementException;
import oadd.org.apache.calcite.avatica.QueryState;
import oadd.org.apache.calcite.avatica.SqlType;
import oadd.org.apache.calcite.avatica.UnregisteredDriver;
import oadd.org.apache.calcite.avatica.remote.KerberosConnection;
import oadd.org.apache.calcite.avatica.remote.Service;
import oadd.org.apache.calcite.avatica.remote.TypedValue;
import oadd.org.apache.calcite.avatica.util.ArrayFactoryImpl;

public abstract class AvaticaConnection
implements Connection {
    public static final String ROWCOUNT_COLUMN_NAME = "ROWCOUNT";
    public static final String NUM_EXECUTE_RETRIES_KEY = "avatica.statement.retries";
    public static final String NUM_EXECUTE_RETRIES_DEFAULT = "5";
    public static final String PLAN_COLUMN_NAME = "PLAN";
    public static final Helper HELPER = Helper.INSTANCE;
    protected int statementCount;
    private boolean closed;
    private int holdability;
    private int networkTimeout;
    private KerberosConnection kerberosConnection;
    private Service service;
    public final String id;
    public final Meta.ConnectionHandle handle;
    protected final UnregisteredDriver driver;
    protected final AvaticaFactory factory;
    final String url;
    protected final Properties info;
    protected final Meta meta;
    protected final AvaticaSpecificDatabaseMetaData metaData;
    public final Map<InternalProperty, Object> properties = new HashMap<InternalProperty, Object>();
    public final Map<Integer, AvaticaStatement> statementMap = new ConcurrentHashMap<Integer, AvaticaStatement>();
    final Map<Integer, AtomicBoolean> flagMap = new ConcurrentHashMap<Integer, AtomicBoolean>();
    protected final long maxRetriesPerExecute;

    protected AvaticaConnection(UnregisteredDriver driver, AvaticaFactory factory, String url, Properties info) {
        this.id = UUID.randomUUID().toString();
        this.handle = new Meta.ConnectionHandle(this.id);
        this.driver = driver;
        this.factory = factory;
        this.url = url;
        this.info = info;
        this.meta = driver.createMeta(this);
        this.metaData = factory.newDatabaseMetaData(this);
        try {
            this.holdability = this.metaData.getResultSetHoldability();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.maxRetriesPerExecute = this.getNumStatementRetries(info);
    }

    long getNumStatementRetries(Properties props) {
        return Long.parseLong(Objects.requireNonNull(props).getProperty(NUM_EXECUTE_RETRIES_KEY, NUM_EXECUTE_RETRIES_DEFAULT));
    }

    public ConnectionConfig config() {
        return new ConnectionConfigImpl(this.info);
    }

    public void openConnection() {
        this.meta.openConnection(this.handle, Service.OpenConnectionRequest.serializeProperties(this.info));
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw HELPER.closed();
        }
    }

    @Override
    public AvaticaStatement createStatement() throws SQLException {
        this.checkOpen();
        return this.createStatement(1003, 1007, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql, 1003, 1007, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setAutoCommit(autoCommit));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.unbox(this.sync().isAutoCommit(), true);
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        this.meta.commit(this.handle);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        this.meta.rollback(this.handle);
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.meta.closeConnection(this.handle);
                this.driver.handler.onConnectionClose(this);
                if (null != this.kerberosConnection) {
                    this.kerberosConnection.stopRenewalThread();
                }
            }
            catch (RuntimeException e) {
                throw HELPER.createException("While closing connection", e);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setReadOnly(readOnly));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.unbox(this.sync().isReadOnly(), true);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setCatalog(catalog));
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.sync().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setTransactionIsolation(level));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.unbox(this.sync().getTransactionIsolation(), 0);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.createStatement(resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("invalid value");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public AvaticaStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this.factory.newStatement(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            Meta.StatementHandle h2 = this.meta.prepare(this.handle, sql, -1L);
            return this.factory.newPreparedStatement(this, h2, h2.signature, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (RuntimeException e) {
            throw HELPER.createException("while preparing SQL: " + sql, e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw HELPER.createException("timeout is less than 0");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw HELPER.clientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw HELPER.clientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getClientInfo().getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        SqlType type;
        this.checkOpen();
        List<Object> elementList = AvaticaUtils.primitiveList(elements);
        try {
            type = SqlType.valueOf(typeName);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Could not find JDBC type for '" + typeName + "'");
        }
        ColumnMetaData.ScalarType avaticaType = null;
        switch (type) {
            case ARRAY: {
                throw HELPER.createException("Cannot create an ARRAY of ARRAY's");
            }
            case STRUCT: {
                throw HELPER.createException("Cannot create an ARRAY of STRUCT's");
            }
        }
        avaticaType = ColumnMetaData.scalar(type.id, typeName, ColumnMetaData.Rep.nonPrimitiveRepOf(type));
        ArrayFactoryImpl arrayFactory = new ArrayFactoryImpl(this.getTimeZone());
        return arrayFactory.createArray(avaticaType, elementList);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setSchema(schema));
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.sync().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw HELPER.unsupported();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
        this.networkTimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        return this.networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw HELPER.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public TimeZone getTimeZone() {
        String timeZoneName = this.config().timeZone();
        return timeZoneName == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet executeQueryInternal(AvaticaStatement statement, Meta.Signature signature, Meta.Frame firstFrame, QueryState state, boolean isUpdate) throws SQLException {
        Meta.Frame frame = firstFrame;
        Meta.Signature signature2 = signature;
        AvaticaStatement avaticaStatement = statement;
        synchronized (avaticaStatement) {
            if (statement.openResultSet != null) {
                AvaticaResultSet rs = statement.openResultSet;
                statement.openResultSet = null;
                try {
                    rs.close();
                }
                catch (Exception e) {
                    throw HELPER.createException("Error while closing previous result set", e);
                }
            }
            try {
                if (statement.isWrapperFor(AvaticaPreparedStatement.class)) {
                    AvaticaPreparedStatement pstmt = (AvaticaPreparedStatement)statement;
                    Meta.StatementHandle handle = pstmt.handle;
                    if (isUpdate) {
                        handle = new Meta.StatementHandle(handle.connectionId, handle.id, null);
                    }
                    Meta.ExecuteResult executeResult = this.meta.execute(handle, pstmt.getParameterValues(), statement.getFetchSize());
                    Meta.MetaResultSet metaResultSet = executeResult.resultSets.get(0);
                    frame = metaResultSet.firstFrame;
                    statement.updateCount = metaResultSet.updateCount;
                    signature2 = executeResult.resultSets.get((int)0).signature;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw HELPER.createException(e.getMessage(), e);
            }
            TimeZone timeZone = this.getTimeZone();
            statement.openResultSet = frame == null && signature2 == null && statement.updateCount != -1L ? null : this.factory.newResultSet(statement, state, signature2, timeZone, frame);
        }
        try {
            if (statement.openResultSet != null) {
                statement.openResultSet.execute();
                this.isUpdateCapable(statement);
            }
        }
        catch (Exception e) {
            throw HELPER.createException("exception while executing query: " + e.getMessage(), e);
        }
        return statement.openResultSet;
    }

    protected long[] executeBatchUpdateInternal(AvaticaPreparedStatement pstmt) throws SQLException {
        try {
            Meta.StatementHandle handle = pstmt.handle;
            return this.meta.executeBatch((Meta.StatementHandle)handle, pstmt.getParameterValueBatch()).updateCounts;
        }
        catch (Exception e) {
            throw HELPER.createException(e.getMessage(), e);
        }
    }

    private void isUpdateCapable(AvaticaStatement statement) throws SQLException {
        Meta.Signature signature = statement.getSignature();
        if (signature == null || signature.statementType == null) {
            return;
        }
        if (signature.statementType.canUpdate() && statement.updateCount == -1L) {
            statement.openResultSet.next();
            Object obj = statement.openResultSet.getObject(ROWCOUNT_COLUMN_NAME);
            if (obj instanceof Number) {
                statement.updateCount = ((Number)obj).intValue();
            } else if (obj instanceof List) {
                List numbers = (List)obj;
                statement.updateCount = ((Number)numbers.get(0)).intValue();
            } else {
                throw HELPER.createException("Not a valid return result.");
            }
            statement.openResultSet = null;
        }
    }

    protected Meta.ExecuteResult prepareAndExecuteInternal(final AvaticaStatement statement, final String sql, long maxRowCount) throws SQLException, NoSuchStatementException {
        Meta.PrepareCallback callback = new Meta.PrepareCallback(){

            @Override
            public Object getMonitor() {
                return statement;
            }

            @Override
            public void clear() throws SQLException {
                if (statement.openResultSet != null) {
                    AvaticaResultSet rs = statement.openResultSet;
                    statement.openResultSet = null;
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        throw HELPER.createException("Error while closing previous result set", e);
                    }
                }
            }

            @Override
            public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) throws SQLException {
                statement.setSignature(signature);
                if (updateCount != -1L) {
                    statement.updateCount = updateCount;
                } else {
                    TimeZone timeZone = AvaticaConnection.this.getTimeZone();
                    statement.openResultSet = AvaticaConnection.this.factory.newResultSet(statement, new QueryState(sql), signature, timeZone, firstFrame);
                }
            }

            @Override
            public void execute() throws SQLException {
                if (statement.openResultSet != null) {
                    statement.openResultSet.execute();
                    AvaticaConnection.this.isUpdateCapable(statement);
                }
            }
        };
        return this.meta.prepareAndExecute(statement.handle, sql, maxRowCount, AvaticaUtils.toSaturatedInt(maxRowCount), callback);
    }

    protected Meta.ExecuteBatchResult prepareAndUpdateBatch(AvaticaStatement statement, List<String> queries) throws NoSuchStatementException, SQLException {
        return this.meta.prepareAndExecuteBatch(statement.handle, queries);
    }

    protected ResultSet createResultSet(Meta.MetaResultSet metaResultSet, QueryState state) throws SQLException {
        Meta.StatementHandle h2 = new Meta.StatementHandle(metaResultSet.connectionId, metaResultSet.statementId, null);
        AvaticaStatement statement = this.lookupStatement(h2);
        ResultSet resultSet = this.executeQueryInternal(statement, metaResultSet.signature.sanitize(), metaResultSet.firstFrame, state, false);
        if (metaResultSet.ownStatement) {
            resultSet.getStatement().closeOnCompletion();
        }
        return resultSet;
    }

    protected AvaticaStatement lookupStatement(Meta.StatementHandle h2) throws SQLException {
        AvaticaStatement statement = this.statementMap.get(h2.id);
        if (statement != null) {
            return statement;
        }
        return this.factory.newStatement(this, Objects.requireNonNull(h2), 1003, 1007, this.holdability);
    }

    protected static Trojan createTrojan() {
        return new Trojan();
    }

    private boolean unbox(Boolean b, boolean defaultValue) {
        return b == null ? defaultValue : b;
    }

    private int unbox(Integer i, int defaultValue) {
        return i == null ? defaultValue : i;
    }

    private Meta.ConnectionProperties sync() {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicBoolean getCancelFlag(Meta.StatementHandle h2) throws NoSuchStatementException {
        AvaticaUtils.upgrade("after dropping JDK 1.7, use Map.computeIfAbsent");
        Map<Integer, AtomicBoolean> map = this.flagMap;
        synchronized (map) {
            AtomicBoolean b = this.flagMap.get(h2.id);
            if (b == null) {
                b = new AtomicBoolean();
                this.flagMap.put(h2.id, b);
            }
            return b;
        }
    }

    public <T> T invokeWithRetries(CallableWithoutException<T> callable) {
        AvaticaClientRuntimeException lastException = null;
        int i = 0;
        while ((long)i < this.maxRetriesPerExecute) {
            try {
                return callable.call();
            }
            catch (AvaticaClientRuntimeException e) {
                lastException = e;
                if (1 != e.getErrorCode()) {
                    throw e;
                }
                this.openConnection();
                ++i;
            }
        }
        if (null != lastException) {
            throw lastException;
        }
        throw new IllegalStateException();
    }

    public void setKerberosConnection(KerberosConnection kerberosConnection) {
        this.kerberosConnection = Objects.requireNonNull(kerberosConnection);
    }

    public KerberosConnection getKerberosConnection() {
        return this.kerberosConnection;
    }

    public Service getService() {
        assert (null != this.service);
        return this.service;
    }

    public void setService(Service service) {
        this.service = Objects.requireNonNull(service);
    }

    public static interface CallableWithoutException<T> {
        public T call();
    }

    public static class Trojan {
        private Trojan() {
        }

        public ResultSet execute(AvaticaResultSet resultSet) throws SQLException {
            return resultSet.execute();
        }

        public List<TypedValue> getParameterValues(AvaticaStatement statement) {
            return statement.getParameterValues();
        }

        public Meta getMeta(AvaticaConnection connection) {
            return connection.meta;
        }
    }
}

