/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.LogicalUtilities;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.json.JsonValue;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.bettercloud.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;

public class Logical {
    private final VaultConfig config;
    private String nameSpace;

    public Logical(VaultConfig config) {
        this.config = config;
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Logical withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public LogicalResponse read(String path) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.read(path, (Boolean)true, logicalOperations.readV2);
        }
        return this.read(path, (Boolean)true, logicalOperations.readV1);
    }

    private LogicalResponse read(String path, Boolean shouldRetry, logicalOperations operation) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForReadOrWrite(path, this.config.getPrefixPathDepth(), operation)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && (restResponse.getStatus() < 400 || restResponse.getStatus() >= 500)) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount, operation);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (!shouldRetry.booleanValue()) {
                    throw new VaultException(e);
                }
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse read(String path, Boolean shouldRetry, Integer version) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Version reads are only supported in KV Engine version 2.");
        }
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForReadOrWrite(path, this.config.getPrefixPathDepth(), logicalOperations.readV2)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).parameter("version", version.toString()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && (restResponse.getStatus() < 400 || restResponse.getStatus() >= 500)) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount, logicalOperations.readV2);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (!shouldRetry.booleanValue()) {
                    throw new VaultException(e);
                }
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse write(String path, Map<String, Object> nameValuePairs) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.write(path, nameValuePairs, logicalOperations.writeV2);
        }
        return this.write(path, nameValuePairs, logicalOperations.writeV1);
    }

    private LogicalResponse write(String path, Map<String, Object> nameValuePairs, logicalOperations operation) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse;
                int restStatus;
                JsonObject requestJson = Json.object();
                if (nameValuePairs != null) {
                    for (Map.Entry<String, Object> pair : nameValuePairs.entrySet()) {
                        Object value = pair.getValue();
                        if (value == null) {
                            requestJson = requestJson.add(pair.getKey(), (String)null);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            requestJson = requestJson.add(pair.getKey(), (Boolean)pair.getValue());
                            continue;
                        }
                        if (value instanceof Integer) {
                            requestJson = requestJson.add(pair.getKey(), (Integer)pair.getValue());
                            continue;
                        }
                        if (value instanceof Long) {
                            requestJson = requestJson.add(pair.getKey(), (Long)pair.getValue());
                            continue;
                        }
                        if (value instanceof Float) {
                            requestJson = requestJson.add(pair.getKey(), ((Float)pair.getValue()).floatValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            requestJson = requestJson.add(pair.getKey(), (Double)pair.getValue());
                            continue;
                        }
                        if (value instanceof JsonValue) {
                            requestJson = requestJson.add(pair.getKey(), (JsonValue)pair.getValue());
                            continue;
                        }
                        requestJson = requestJson.add(pair.getKey(), pair.getValue().toString());
                    }
                }
                if ((restStatus = (restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForReadOrWrite(path, this.config.getPrefixPathDepth(), operation)).body(LogicalUtilities.jsonObjectToWriteFromEngineVersion(operation, requestJson).toString().getBytes(StandardCharsets.UTF_8)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post()).getStatus()) == 200 || restStatus == 204 || restResponse.getStatus() >= 400 && restResponse.getStatus() < 500) {
                    return new LogicalResponse(restResponse, retryCount, operation);
                }
                throw new VaultException("Expecting HTTP status 204 or 200, but instead receiving " + restStatus + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restStatus);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse list(String path) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.list(path, logicalOperations.listV2);
        }
        return this.list(path, logicalOperations.listV1);
    }

    private LogicalResponse list(String path, logicalOperations operation) throws VaultException {
        LogicalResponse response;
        block2: {
            response = null;
            try {
                response = this.read(LogicalUtilities.adjustPathForList(path, this.config.getPrefixPathDepth(), operation), (Boolean)true, operation);
            }
            catch (VaultException e) {
                if (e.getHttpStatusCode() == 404) break block2;
                throw e;
            }
        }
        return response;
    }

    public LogicalResponse delete(String path) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.delete(path, logicalOperations.deleteV2);
        }
        return this.delete(path, logicalOperations.deleteV1);
    }

    private LogicalResponse delete(String path, logicalOperations operation) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForDelete(path, this.config.getPrefixPathDepth(), operation)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount, operation);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse delete(String path, int[] versions) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Version deletes are only supported for KV Engine 2.");
        }
        this.intArrayCheck(versions);
        int retryCount = 0;
        while (true) {
            try {
                JsonObject versionsToDelete = new JsonObject().add("versions", versions);
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForVersionDelete(path, this.config.getPrefixPathDepth())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(versionsToDelete.toString().getBytes(StandardCharsets.UTF_8)).post();
                return this.getLogicalResponse(retryCount, restResponse);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    private LogicalResponse getLogicalResponse(int retryCount, RestResponse restResponse) throws VaultException {
        if (restResponse.getStatus() != 204) {
            throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
        }
        return new LogicalResponse(restResponse, retryCount, logicalOperations.deleteV2);
    }

    private void intArrayCheck(int[] versions) {
        for (int i : versions) {
            if (i >= 1) continue;
            throw new IllegalArgumentException("The document version must be 1 or greater.");
        }
        Arrays.sort(versions);
    }

    public LogicalResponse unDelete(String path, int[] versions) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Version undeletes are only supported for KV Engine 2.");
        }
        this.intArrayCheck(versions);
        int retryCount = 0;
        while (true) {
            try {
                JsonObject versionsToUnDelete = new JsonObject().add("versions", versions);
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForVersionUnDelete(path, this.config.getPrefixPathDepth())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(versionsToUnDelete.toString().getBytes(StandardCharsets.UTF_8)).post();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount, logicalOperations.unDelete);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse destroy(String path, int[] versions) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Secret destroys are only supported for KV Engine 2.");
        }
        this.intArrayCheck(versions);
        int retryCount = 0;
        while (true) {
            try {
                JsonObject versionsToDestroy = new JsonObject().add("versions", versions);
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForVersionDestroy(path, this.config.getPrefixPathDepth())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(versionsToDestroy.toString().getBytes(StandardCharsets.UTF_8)).post();
                return this.getLogicalResponse(retryCount, restResponse);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse upgrade(String kvPath) throws VaultException {
        if (this.engineVersionForSecretPath(kvPath) == 2) {
            throw new VaultException("This KV engine is already version 2.");
        }
        int retryCount = 0;
        while (true) {
            try {
                JsonObject kvToUpgrade = new JsonObject().add("options", new JsonObject().add("version", 2));
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/mounts/" + kvPath.replaceAll("/", "") + "/tune").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(kvToUpgrade.toString().getBytes(StandardCharsets.UTF_8)).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount, logicalOperations.authentication);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    private Integer engineVersionForSecretPath(String secretPath) {
        if (!this.config.getSecretsEnginePathMap().isEmpty()) {
            return this.config.getSecretsEnginePathMap().containsKey(secretPath + "/") ? Integer.valueOf(this.config.getSecretsEnginePathMap().get(secretPath + "/")) : this.config.getGlobalEngineVersion();
        }
        return this.config.getGlobalEngineVersion();
    }

    public Integer getEngineVersionForSecretPath(String path) {
        return this.engineVersionForSecretPath(path);
    }

    public static enum logicalOperations {
        authentication,
        deleteV1,
        deleteV2,
        destroy,
        listV1,
        listV2,
        readV1,
        readV2,
        writeV1,
        writeV2,
        unDelete,
        mount;

    }
}

