/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault;

import com.bettercloud.vault.EnvironmentLoader;
import com.bettercloud.vault.VaultException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VAULT_SSL_VERIFY = "VAULT_SSL_VERIFY";
    private static final String VAULT_SSL_CERT = "VAULT_SSL_CERT";
    private boolean verify;
    private transient SSLContext sslContext;
    private transient KeyStore trustStore;
    private transient KeyStore keyStore;
    private String keyStorePassword;
    private String pemUTF8;
    private String clientPemUTF8;
    private String clientKeyPemUTF8;
    private Boolean verifyObject;
    private EnvironmentLoader environmentLoader;

    protected SslConfig environmentLoader(EnvironmentLoader environmentLoader) {
        this.environmentLoader = environmentLoader;
        return this;
    }

    public SslConfig verify(Boolean verify) {
        this.verifyObject = verify;
        return this;
    }

    public SslConfig keyStore(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        return this;
    }

    public SslConfig keyStoreFile(File keyStoreFile, String password) throws VaultException {
        SslConfig sslConfig;
        FileInputStream inputStream = new FileInputStream(keyStoreFile);
        try {
            this.keyStore = this.inputStreamToKeyStore(inputStream, password);
            this.keyStorePassword = password;
            sslConfig = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VaultException(e);
            }
        }
        ((InputStream)inputStream).close();
        return sslConfig;
    }

    public SslConfig keyStoreResource(String classpathResource, String password) throws VaultException {
        SslConfig sslConfig;
        block8: {
            InputStream inputStream = this.getClass().getResourceAsStream(classpathResource);
            try {
                this.keyStore = this.inputStreamToKeyStore(inputStream, password);
                this.keyStorePassword = password;
                sslConfig = this;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new VaultException(e);
                }
            }
            inputStream.close();
        }
        return sslConfig;
    }

    public SslConfig trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public SslConfig trustStoreFile(File trustStoreFile) throws VaultException {
        SslConfig sslConfig;
        FileInputStream inputStream = new FileInputStream(trustStoreFile);
        try {
            this.trustStore = this.inputStreamToKeyStore(inputStream, null);
            sslConfig = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VaultException(e);
            }
        }
        ((InputStream)inputStream).close();
        return sslConfig;
    }

    public SslConfig trustStoreResource(String classpathResource) throws VaultException {
        SslConfig sslConfig;
        block8: {
            InputStream inputStream = this.getClass().getResourceAsStream(classpathResource);
            try {
                this.trustStore = this.inputStreamToKeyStore(inputStream, null);
                sslConfig = this;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new VaultException(e);
                }
            }
            inputStream.close();
        }
        return sslConfig;
    }

    public SslConfig pemUTF8(String pemUTF8) {
        this.pemUTF8 = pemUTF8;
        return this;
    }

    public SslConfig pemFile(File pemFile) throws VaultException {
        try (FileInputStream input = new FileInputStream(pemFile);){
            this.pemUTF8 = SslConfig.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public SslConfig pemResource(String classpathResource) throws VaultException {
        try (InputStream input = this.getClass().getResourceAsStream(classpathResource);){
            this.pemUTF8 = SslConfig.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public SslConfig clientPemUTF8(String clientPemUTF8) {
        this.clientPemUTF8 = clientPemUTF8;
        return this;
    }

    public SslConfig clientPemFile(File clientPemFile) throws VaultException {
        try (FileInputStream input = new FileInputStream(clientPemFile);){
            this.clientPemUTF8 = SslConfig.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public SslConfig clientPemResource(String classpathResource) throws VaultException {
        try (InputStream input = this.getClass().getResourceAsStream(classpathResource);){
            this.clientPemUTF8 = SslConfig.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public SslConfig clientKeyPemUTF8(String clientKeyPemUTF8) {
        this.clientKeyPemUTF8 = clientKeyPemUTF8;
        return this;
    }

    public SslConfig clientKeyPemFile(File clientKeyPemFile) throws VaultException {
        try (FileInputStream input = new FileInputStream(clientKeyPemFile);){
            this.clientKeyPemUTF8 = SslConfig.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public SslConfig clientKeyPemResource(String classpathResource) throws VaultException {
        try (InputStream input = this.getClass().getResourceAsStream(classpathResource);){
            this.clientKeyPemUTF8 = SslConfig.inputStreamToUTF8(input);
        }
        catch (IOException e) {
            throw new VaultException(e);
        }
        return this;
    }

    public SslConfig build() throws VaultException {
        if (this.environmentLoader == null) {
            this.environmentLoader = new EnvironmentLoader();
        }
        this.verify = this.verifyObject == null && this.environmentLoader.loadVariable(VAULT_SSL_VERIFY) != null ? Boolean.parseBoolean(this.environmentLoader.loadVariable(VAULT_SSL_VERIFY)) : (this.verifyObject != null ? this.verifyObject : true);
        if (this.verify && this.pemUTF8 == null && this.environmentLoader.loadVariable(VAULT_SSL_CERT) != null) {
            File pemFile = new File(this.environmentLoader.loadVariable(VAULT_SSL_CERT));
            try (FileInputStream input = new FileInputStream(pemFile);){
                this.pemUTF8 = SslConfig.inputStreamToUTF8(input);
            }
            catch (IOException e) {
                throw new VaultException(e);
            }
        }
        this.buildSsl();
        return this;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    protected String getPemUTF8() {
        return this.pemUTF8;
    }

    private void buildSsl() throws VaultException {
        if (this.verify) {
            if (this.keyStore != null || this.trustStore != null) {
                this.sslContext = this.buildSslContextFromJks();
            } else if (this.pemUTF8 != null || this.clientPemUTF8 != null || this.clientKeyPemUTF8 != null) {
                this.sslContext = this.buildSslContextFromPem();
            }
        }
    }

    private SSLContext buildSslContextFromJks() throws VaultException {
        TrustManager[] trustManagers = null;
        if (this.trustStore != null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(this.trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new VaultException(e);
            }
        }
        KeyManager[] keyManagers = null;
        if (this.keyStore != null) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(this.keyStore, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new VaultException(e);
            }
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new VaultException(e);
        }
    }

    private SSLContext buildSslContextFromPem() throws VaultException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            TrustManager[] trustManagers = null;
            if (this.pemUTF8 != null) {
                X509Certificate certificate;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                try (ByteArrayInputStream pem = new ByteArrayInputStream(this.pemUTF8.getBytes(StandardCharsets.UTF_8));){
                    certificate = (X509Certificate)certificateFactory.generateCertificate(pem);
                }
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null);
                keyStore.setCertificateEntry("caCert", certificate);
                trustManagerFactory.init(keyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            KeyManager[] keyManagers = null;
            if (this.clientPemUTF8 != null && this.clientKeyPemUTF8 != null) {
                X509Certificate clientCertificate;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                try (ByteArrayInputStream pem = new ByteArrayInputStream(this.clientPemUTF8.getBytes(StandardCharsets.UTF_8));){
                    clientCertificate = (X509Certificate)certificateFactory.generateCertificate(pem);
                }
                String strippedKey = this.clientKeyPemUTF8.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
                byte[] keyBytes = Base64.getMimeDecoder().decode(strippedKey);
                PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
                KeyFactory factory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, "password".toCharArray());
                keyStore.setCertificateEntry("clientCert", clientCertificate);
                keyStore.setKeyEntry("key", privateKey, "password".toCharArray(), new Certificate[]{clientCertificate});
                keyManagerFactory.init(keyStore, "password".toCharArray());
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new VaultException(e);
        }
    }

    private KeyStore inputStreamToKeyStore(InputStream inputStream, String password) throws VaultException {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, password == null ? null : password.toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new VaultException(e);
        }
    }

    private static String inputStreamToUTF8(InputStream input) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        StringBuilder utf8 = new StringBuilder();
        while ((str = in.readLine()) != null) {
            utf8.append(str).append(System.lineSeparator());
        }
        in.close();
        return utf8.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.buildSsl();
        }
        catch (VaultException e) {
            throw new IOException(e);
        }
    }
}

