/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.sql.NClob;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLXML;
import java.util.Properties;
import java.util.TimeZone;
import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.AvaticaFactory;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.Helper;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.QueryState;
import oadd.org.apache.drill.exec.client.DrillClient;
import oadd.org.apache.drill.exec.client.ServerMethod;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillDatabaseMetaDataImpl;
import org.apache.drill.jdbc.impl.DrillFactory;
import org.apache.drill.jdbc.impl.DrillPreparedStatementImpl;
import org.apache.drill.jdbc.impl.DrillResultSetImpl;
import org.apache.drill.jdbc.impl.DrillResultSetMetaDataImpl;
import org.apache.drill.jdbc.impl.DrillStatementImpl;
import org.apache.drill.jdbc.impl.DriverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillJdbc41Factory
extends DrillFactory {
    private static final Logger logger = LoggerFactory.getLogger(DrillJdbc41Factory.class);

    public DrillJdbc41Factory() {
        this(4, 1);
    }

    protected DrillJdbc41Factory(int major, int minor) {
        super(major, minor);
    }

    @Override
    DrillConnectionImpl newDrillConnection(DriverImpl driver, DrillFactory factory, String url, Properties info) throws SQLException {
        return new DrillConnectionImpl(driver, (AvaticaFactory)factory, url, info);
    }

    @Override
    public DrillDatabaseMetaDataImpl newDatabaseMetaData(AvaticaConnection connection) {
        return new DrillDatabaseMetaDataImpl((DrillConnectionImpl)connection);
    }

    @Override
    public DrillStatementImpl newStatement(AvaticaConnection connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new DrillStatementImpl((DrillConnectionImpl)connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public DrillJdbc41PreparedStatement newPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DrillConnectionImpl drillConnection = (DrillConnectionImpl)connection;
        DrillClient client = drillConnection.getClient();
        if (drillConnection.getConfig().isServerPreparedStatementDisabled() || !client.getSupportedMethods().contains((Object)ServerMethod.PREPARED_STATEMENT)) {
            return new DrillJdbc41PreparedStatement(drillConnection, h, signature, null, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.newServerPreparedStatement(drillConnection, h, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private DrillJdbc41PreparedStatement newServerPreparedStatement(DrillConnectionImpl connection, Meta.StatementHandle h, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String sql = signature.sql;
        try {
            UserProtos.CreatePreparedStatementResp resp;
            DrillRpcFuture<UserProtos.CreatePreparedStatementResp> respFuture = connection.getClient().createPreparedStatement(signature.sql);
            try {
                resp = (UserProtos.CreatePreparedStatementResp)respFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted", e);
            }
            UserProtos.RequestStatus status = resp.getStatus();
            if (status != UserProtos.RequestStatus.OK) {
                String errMsgFromServer;
                String string = errMsgFromServer = resp.getError() != null ? resp.getError().getMessage() : "";
                if (status == UserProtos.RequestStatus.TIMEOUT) {
                    logger.error("Request timed out to create prepare statement: {}", (Object)errMsgFromServer);
                    throw new SQLTimeoutException("Failed to create prepared statement: " + errMsgFromServer);
                }
                if (status == UserProtos.RequestStatus.FAILED) {
                    logger.error("Failed to create prepared statement: {}", (Object)errMsgFromServer);
                    throw new SQLException("Failed to create prepared statement: " + errMsgFromServer);
                }
                logger.error("Failed to create prepared statement. Unknown status: {}, Error: {}", (Object)status, (Object)errMsgFromServer);
                throw new SQLException(String.format("Failed to create prepared statement. Unknown status: %s, Error: %s", status, errMsgFromServer));
            }
            return new DrillJdbc41PreparedStatement(connection, h, signature, resp.getPreparedStatement(), resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    @Override
    public DrillResultSetImpl newResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, TimeZone timeZone, Meta.Frame firstFrame) {
        ResultSetMetaData metaData = this.newResultSetMetaData(statement, signature);
        return new DrillResultSetImpl(statement, state, signature, metaData, timeZone, firstFrame);
    }

    @Override
    public ResultSetMetaData newResultSetMetaData(AvaticaStatement statement, Meta.Signature signature) {
        return new DrillResultSetMetaDataImpl(statement, null, signature);
    }

    private static class DrillJdbc41PreparedStatement
    extends DrillPreparedStatementImpl {
        DrillJdbc41PreparedStatement(DrillConnectionImpl connection, Meta.StatementHandle h, Meta.Signature signature, UserProtos.PreparedStatement pstmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            super(connection, h, signature, pstmt, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public void setRowId(int parameterIndex, RowId x) throws SQLException {
            this.getSite(parameterIndex).setRowId(x);
        }

        @Override
        public void setNString(int parameterIndex, String value) throws SQLException {
            this.getSite(parameterIndex).setNString(value);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
            this.getSite(parameterIndex).setNCharacterStream(value, length);
        }

        @Override
        public void setNClob(int parameterIndex, NClob value) throws SQLException {
            this.getSite(parameterIndex).setNClob(value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.getSite(parameterIndex).setClob(reader, length);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
            this.getSite(parameterIndex).setBlob(inputStream, length);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.getSite(parameterIndex).setNClob(reader, length);
        }

        @Override
        public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
            this.getSite(parameterIndex).setSQLXML(xmlObject);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.getSite(parameterIndex).setAsciiStream(x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.getSite(parameterIndex).setBinaryStream(x, length);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
            this.getSite(parameterIndex).setCharacterStream(reader, length);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
            this.getSite(parameterIndex).setAsciiStream(x);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
            this.getSite(parameterIndex).setBinaryStream(x);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
            this.getSite(parameterIndex).setCharacterStream(reader);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
            this.getSite(parameterIndex).setNCharacterStream(value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader) throws SQLException {
            this.getSite(parameterIndex).setClob(reader);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
            this.getSite(parameterIndex).setBlob(inputStream);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader) throws SQLException {
            this.getSite(parameterIndex).setNClob(reader);
        }
    }
}

