/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.codehaus.janino.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oadd.org.codehaus.janino.JaninoRuntimeException;
import oadd.org.codehaus.janino.util.ClassFile;
import oadd.org.codehaus.janino.util.resource.Resource;
import oadd.org.codehaus.janino.util.resource.ResourceFinder;

public class ResourceFinderClassLoader
extends ClassLoader {
    private final ResourceFinder resourceFinder;

    public ResourceFinderClassLoader(ResourceFinder resourceFinder, ClassLoader parent) {
        super(parent);
        this.resourceFinder = resourceFinder;
    }

    public ResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        InputStream is;
        Resource classFileResource = this.resourceFinder.findResource(ClassFile.getClassFileResourceName(className));
        if (classFileResource == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            is = classFileResource.open();
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException("Opening class file resource \"" + classFileResource.getFileName() + "\": " + ex.getMessage(), ex);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Reading class file from \"" + classFileResource + "\"", ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
        byte[] ba = baos.toByteArray();
        Class<?> clazz = super.defineClass(null, ba, 0, ba.length);
        if (!clazz.getName().equals(className)) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }
}

