/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.codehaus.commons.compiler;

import java.io.File;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oadd.org.codehaus.commons.compiler.CompilerFactoryFactory;

public abstract class AbstractJavaSourceClassLoader
extends ClassLoader {
    protected ProtectionDomainFactory optionalProtectionDomainFactory;

    public AbstractJavaSourceClassLoader() {
    }

    public AbstractJavaSourceClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public abstract void setSourcePath(File[] var1);

    public abstract void setSourceFileCharacterEncoding(String var1);

    public abstract void setDebuggingInfo(boolean var1, boolean var2, boolean var3);

    public final void setProtectionDomainFactory(ProtectionDomainFactory optionalProtectionDomainFactory) {
        this.optionalProtectionDomainFactory = optionalProtectionDomainFactory;
    }

    public static void main(String[] args) throws Exception {
        Method mainMethod;
        String arg;
        int i;
        File[] optionalSourcePath = null;
        String optionalCharacterEncoding = null;
        boolean debuggingInfoLines = false;
        boolean debuggingInfoVars = false;
        boolean debuggingInfoSource = false;
        boolean haveDebuggingInfo = false;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if ("-sourcepath".equals(arg)) {
                optionalSourcePath = AbstractJavaSourceClassLoader.splitPath(args[++i]);
                continue;
            }
            if ("-encoding".equals(arg)) {
                optionalCharacterEncoding = args[++i];
                continue;
            }
            if ("-g".equals(arg)) {
                debuggingInfoLines = true;
                debuggingInfoVars = true;
                debuggingInfoSource = true;
                haveDebuggingInfo = true;
                continue;
            }
            if ("-g:none".equals(arg)) {
                debuggingInfoLines = false;
                debuggingInfoVars = false;
                debuggingInfoSource = false;
                haveDebuggingInfo = true;
                continue;
            }
            if ("-g:".startsWith(arg)) {
                debuggingInfoLines = arg.indexOf("lines") != -1;
                debuggingInfoVars = arg.indexOf("vars") != -1;
                debuggingInfoSource = arg.indexOf("source") != -1;
                haveDebuggingInfo = true;
                continue;
            }
            if ("-help".equals(arg)) {
                System.out.println("Usage:");
                System.out.println("  java " + AbstractJavaSourceClassLoader.class.getName() + " { <option> } <class-name> { <argument> }");
                System.out.println("Loads the named class by name and invoke its \"main(String[])\" method, passing");
                System.out.println("the given <argument>s.");
                System.out.println("  <option>:");
                System.out.println("    -sourcepath <" + File.pathSeparator + "-separated-list-of-source-directories>");
                System.out.println("    -encoding <character-encoding>");
                System.out.println("    -g                     Generate all debugging info");
                System.out.println("    -g:none                Generate no debugging info");
                System.out.println("    -g:{source,lines,vars} Generate only some debugging info");
                System.exit(0);
                continue;
            }
            System.err.println("Invalid command line option \"" + arg + "\"; try \"-help\"");
            System.exit(1);
        }
        if (i == args.length) {
            System.err.println("No class name given, try \"-help\"");
            System.exit(1);
        }
        String className = args[i++];
        String[] mainArgs = new String[args.length - i];
        System.arraycopy(args, i, mainArgs, 0, args.length - i);
        AbstractJavaSourceClassLoader ajscl = CompilerFactoryFactory.getDefaultCompilerFactory().newJavaSourceClassLoader();
        if (haveDebuggingInfo) {
            ajscl.setDebuggingInfo(debuggingInfoLines, debuggingInfoVars, debuggingInfoSource);
        }
        if (optionalCharacterEncoding != null) {
            ajscl.setSourceFileCharacterEncoding(optionalCharacterEncoding);
        }
        if (optionalSourcePath != null) {
            ajscl.setSourcePath(optionalSourcePath);
        }
        Class<?> clazz = ajscl.loadClass(className);
        try {
            mainMethod = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            System.err.println("Class \"" + className + "\" has not public method \"main(String[])\".");
            System.exit(1);
            return;
        }
        mainMethod.invoke(null, new Object[]{mainArgs});
    }

    private static File[] splitPath(String string) {
        ArrayList<File> l = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(string, File.pathSeparator);
        while (st.hasMoreTokens()) {
            l.add(new File(st.nextToken()));
        }
        return l.toArray(new File[l.size()]);
    }

    public static interface ProtectionDomainFactory {
        public ProtectionDomain getProtectionDomain(String var1);
    }
}

