/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.io.DataInput;
import java.io.IOException;
import oadd.com.google.protobuf.ByteString;
import oadd.org.apache.hadoop.ipc.RPC;
import oadd.org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import oadd.org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import oadd.org.apache.hadoop.security.SaslRpcServer;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;

public abstract class ProtoUtil {
    public static int readRawVarint32(DataInput in) throws IOException {
        byte tmp = in.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = in.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = in.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = in.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = in.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (in.readByte() < 0) continue;
                            return result;
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return result;
    }

    public static IpcConnectionContextProtos.IpcConnectionContextProto makeIpcConnectionContext(String protocol, UserGroupInformation ugi, SaslRpcServer.AuthMethod authMethod) {
        IpcConnectionContextProtos.IpcConnectionContextProto.Builder result = IpcConnectionContextProtos.IpcConnectionContextProto.newBuilder();
        if (protocol != null) {
            result.setProtocol(protocol);
        }
        IpcConnectionContextProtos.UserInformationProto.Builder ugiProto = IpcConnectionContextProtos.UserInformationProto.newBuilder();
        if (ugi != null) {
            if (authMethod == SaslRpcServer.AuthMethod.KERBEROS) {
                ugiProto.setEffectiveUser(ugi.getUserName());
            } else if (authMethod != SaslRpcServer.AuthMethod.TOKEN) {
                ugiProto.setEffectiveUser(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    ugiProto.setRealUser(ugi.getRealUser().getUserName());
                }
            }
        }
        result.setUserInfo(ugiProto);
        return result.build();
    }

    public static UserGroupInformation getUgi(IpcConnectionContextProtos.IpcConnectionContextProto context) {
        if (context.hasUserInfo()) {
            IpcConnectionContextProtos.UserInformationProto userInfo = context.getUserInfo();
            return ProtoUtil.getUgi(userInfo);
        }
        return null;
    }

    public static UserGroupInformation getUgi(IpcConnectionContextProtos.UserInformationProto userInfo) {
        String realUser;
        UserGroupInformation ugi = null;
        String effectiveUser = userInfo.hasEffectiveUser() ? userInfo.getEffectiveUser() : null;
        String string = realUser = userInfo.hasRealUser() ? userInfo.getRealUser() : null;
        if (effectiveUser != null) {
            if (realUser != null) {
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(realUser);
                ugi = UserGroupInformation.createProxyUser(effectiveUser, realUserUgi);
            } else {
                ugi = UserGroupInformation.createRemoteUser(effectiveUser);
            }
        }
        return ugi;
    }

    static RpcHeaderProtos.RpcKindProto convert(RPC.RpcKind kind) {
        switch (kind) {
            case RPC_BUILTIN: {
                return RpcHeaderProtos.RpcKindProto.RPC_BUILTIN;
            }
            case RPC_WRITABLE: {
                return RpcHeaderProtos.RpcKindProto.RPC_WRITABLE;
            }
            case RPC_PROTOCOL_BUFFER: {
                return RpcHeaderProtos.RpcKindProto.RPC_PROTOCOL_BUFFER;
            }
        }
        return null;
    }

    public static RPC.RpcKind convert(RpcHeaderProtos.RpcKindProto kind) {
        switch (kind) {
            case RPC_BUILTIN: {
                return RPC.RpcKind.RPC_BUILTIN;
            }
            case RPC_WRITABLE: {
                return RPC.RpcKind.RPC_WRITABLE;
            }
            case RPC_PROTOCOL_BUFFER: {
                return RPC.RpcKind.RPC_PROTOCOL_BUFFER;
            }
        }
        return null;
    }

    public static RpcHeaderProtos.RpcRequestHeaderProto makeRpcRequestHeader(RPC.RpcKind rpcKind, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto operation, int callId, int retryCount, byte[] uuid) {
        RpcHeaderProtos.RpcRequestHeaderProto.Builder result = RpcHeaderProtos.RpcRequestHeaderProto.newBuilder();
        result.setRpcKind(ProtoUtil.convert(rpcKind)).setRpcOp(operation).setCallId(callId).setRetryCount(retryCount).setClientId(ByteString.copyFrom(uuid));
        if (Trace.isTracing()) {
            Span s = Trace.currentSpan();
            result.setTraceInfo(RpcHeaderProtos.RPCTraceInfoProto.newBuilder().setParentId(s.getSpanId()).setTraceId(s.getTraceId()).build());
        }
        return result.build();
    }
}

