/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public final class ExitUtil {
    private static final Log LOG = LogFactory.getLog(ExitUtil.class.getName());
    private static volatile boolean systemExitDisabled = false;
    private static volatile boolean systemHaltDisabled = false;
    private static volatile ExitException firstExitException;
    private static volatile HaltException firstHaltException;

    public static void disableSystemExit() {
        systemExitDisabled = true;
    }

    public static void disableSystemHalt() {
        systemHaltDisabled = true;
    }

    public static boolean terminateCalled() {
        return firstExitException != null;
    }

    public static boolean haltCalled() {
        return firstHaltException != null;
    }

    public static ExitException getFirstExitException() {
        return firstExitException;
    }

    public static HaltException getFirstHaltException() {
        return firstHaltException;
    }

    public static void resetFirstExitException() {
        firstExitException = null;
    }

    public static void resetFirstHaltException() {
        firstHaltException = null;
    }

    public static void terminate(int status, String msg) throws ExitException {
        LOG.info("Exiting with status " + status);
        if (systemExitDisabled) {
            ExitException ee = new ExitException(status, msg);
            LOG.fatal("Terminate called", ee);
            if (null == firstExitException) {
                firstExitException = ee;
            }
            throw ee;
        }
        System.exit(status);
    }

    public static void halt(int status, String msg) throws HaltException {
        LOG.info("Halt with status " + status + " Message: " + msg);
        if (systemHaltDisabled) {
            HaltException ee = new HaltException(status, msg);
            LOG.fatal("Halt called", ee);
            if (null == firstHaltException) {
                firstHaltException = ee;
            }
            throw ee;
        }
        Runtime.getRuntime().halt(status);
    }

    public static void terminate(int status, Throwable t) throws ExitException {
        ExitUtil.terminate(status, StringUtils.stringifyException(t));
    }

    public static void halt(int status, Throwable t) throws HaltException {
        ExitUtil.halt(status, StringUtils.stringifyException(t));
    }

    public static void terminate(int status) throws ExitException {
        ExitUtil.terminate(status, "ExitException");
    }

    public static void halt(int status) throws HaltException {
        ExitUtil.halt(status, "HaltException");
    }

    public static class HaltException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final int status;

        public HaltException(int status, String msg) {
            super(msg);
            this.status = status;
        }
    }

    public static class ExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status, String msg) {
            super(msg);
            this.status = status;
        }
    }
}

