/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.MetricsException;
import oadd.org.apache.hadoop.metrics2.MetricsSystem;
import oadd.org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import oadd.org.apache.hadoop.metrics2.lib.UniqueNames;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum DefaultMetricsSystem {
    INSTANCE;

    private AtomicReference<MetricsSystem> impl = new AtomicReference<MetricsSystemImpl>(new MetricsSystemImpl());
    volatile boolean miniClusterMode = false;
    final transient UniqueNames mBeanNames = new UniqueNames();
    final transient UniqueNames sourceNames = new UniqueNames();

    public static MetricsSystem initialize(String prefix) {
        return INSTANCE.init(prefix);
    }

    MetricsSystem init(String prefix) {
        return this.impl.get().init(prefix);
    }

    public static MetricsSystem instance() {
        return INSTANCE.getImpl();
    }

    public static void shutdown() {
        INSTANCE.shutdownInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownInstance() {
        boolean last = this.impl.get().shutdown();
        if (last) {
            DefaultMetricsSystem defaultMetricsSystem = this;
            synchronized (defaultMetricsSystem) {
                this.mBeanNames.map.clear();
                this.sourceNames.map.clear();
            }
        }
    }

    @InterfaceAudience.Private
    public static MetricsSystem setInstance(MetricsSystem ms) {
        return INSTANCE.setImpl(ms);
    }

    MetricsSystem setImpl(MetricsSystem ms) {
        return this.impl.getAndSet(ms);
    }

    MetricsSystem getImpl() {
        return this.impl.get();
    }

    @InterfaceAudience.Private
    public static void setMiniClusterMode(boolean choice) {
        DefaultMetricsSystem.INSTANCE.miniClusterMode = choice;
    }

    @InterfaceAudience.Private
    public static boolean inMiniClusterMode() {
        return DefaultMetricsSystem.INSTANCE.miniClusterMode;
    }

    @InterfaceAudience.Private
    public static ObjectName newMBeanName(String name) {
        return INSTANCE.newObjectName(name);
    }

    @InterfaceAudience.Private
    public static void removeMBeanName(ObjectName name) {
        INSTANCE.removeObjectName(name.toString());
    }

    @InterfaceAudience.Private
    public static String sourceName(String name, boolean dupOK) {
        return INSTANCE.newSourceName(name, dupOK);
    }

    synchronized ObjectName newObjectName(String name) {
        try {
            if (this.mBeanNames.map.containsKey(name) && !this.miniClusterMode) {
                throw new MetricsException(name + " already exists!");
            }
            return new ObjectName(this.mBeanNames.uniqueName(name));
        }
        catch (Exception e) {
            throw new MetricsException(e);
        }
    }

    synchronized void removeObjectName(String name) {
        this.mBeanNames.map.remove(name);
    }

    synchronized String newSourceName(String name, boolean dupOK) {
        if (this.sourceNames.map.containsKey(name)) {
            if (dupOK) {
                return name;
            }
            if (!this.miniClusterMode) {
                throw new MetricsException("Metrics source " + name + " already exists!");
            }
        }
        return this.sourceNames.uniqueName(name);
    }
}

