/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.file.tfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.io.Text;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Utils {
    private Utils() {
    }

    public static void writeVInt(DataOutput out, int n) throws IOException {
        Utils.writeVLong(out, n);
    }

    public static void writeVLong(DataOutput out, long n) throws IOException {
        if (n < 128L && n >= -32L) {
            out.writeByte((int)n);
            return;
        }
        long un = n < 0L ? n ^ 0xFFFFFFFFFFFFFFFFL : n;
        int len = (64 - Long.numberOfLeadingZeros(un)) / 8 + 1;
        int firstByte = (int)(n >> (len - 1) * 8);
        switch (len) {
            case 1: {
                firstByte >>= 8;
            }
            case 2: {
                if (firstByte < 20 && firstByte >= -20) {
                    out.writeByte(firstByte - 52);
                    out.writeByte((int)n);
                    return;
                }
                firstByte >>= 8;
            }
            case 3: {
                if (firstByte < 16 && firstByte >= -16) {
                    out.writeByte(firstByte - 88);
                    out.writeShort((int)n);
                    return;
                }
                firstByte >>= 8;
            }
            case 4: {
                if (firstByte < 8 && firstByte >= -8) {
                    out.writeByte(firstByte - 112);
                    out.writeShort((int)n >>> 8);
                    out.writeByte((int)n);
                    return;
                }
                out.writeByte(len - 129);
                out.writeInt((int)n);
                return;
            }
            case 5: {
                out.writeByte(len - 129);
                out.writeInt((int)(n >>> 8));
                out.writeByte((int)n);
                return;
            }
            case 6: {
                out.writeByte(len - 129);
                out.writeInt((int)(n >>> 16));
                out.writeShort((int)n);
                return;
            }
            case 7: {
                out.writeByte(len - 129);
                out.writeInt((int)(n >>> 24));
                out.writeShort((int)(n >>> 8));
                out.writeByte((int)n);
                return;
            }
            case 8: {
                out.writeByte(len - 129);
                out.writeLong(n);
                return;
            }
        }
        throw new RuntimeException("Internel error");
    }

    public static int readVInt(DataInput in) throws IOException {
        long ret = Utils.readVLong(in);
        if (ret > Integer.MAX_VALUE || ret < Integer.MIN_VALUE) {
            throw new RuntimeException("Number too large to be represented as Integer");
        }
        return (int)ret;
    }

    public static long readVLong(DataInput in) throws IOException {
        byte firstByte = in.readByte();
        if (firstByte >= -32) {
            return firstByte;
        }
        switch ((firstByte + 128) / 8) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return firstByte + 52 << 8 | in.readUnsignedByte();
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return firstByte + 88 << 16 | in.readUnsignedShort();
            }
            case 1: 
            case 2: {
                return firstByte + 112 << 24 | in.readUnsignedShort() << 8 | in.readUnsignedByte();
            }
            case 0: {
                int len = firstByte + 129;
                switch (len) {
                    case 4: {
                        return in.readInt();
                    }
                    case 5: {
                        return (long)in.readInt() << 8 | (long)in.readUnsignedByte();
                    }
                    case 6: {
                        return (long)in.readInt() << 16 | (long)in.readUnsignedShort();
                    }
                    case 7: {
                        return (long)in.readInt() << 24 | (long)(in.readUnsignedShort() << 8) | (long)in.readUnsignedByte();
                    }
                    case 8: {
                        return in.readLong();
                    }
                }
                throw new IOException("Corrupted VLong encoding");
            }
        }
        throw new RuntimeException("Internal error");
    }

    public static void writeString(DataOutput out, String s) throws IOException {
        if (s != null) {
            Text text = new Text(s);
            byte[] buffer = text.getBytes();
            int len = text.getLength();
            Utils.writeVInt(out, len);
            out.write(buffer, 0, len);
        } else {
            Utils.writeVInt(out, -1);
        }
    }

    public static String readString(DataInput in) throws IOException {
        int length = Utils.readVInt(in);
        if (length == -1) {
            return null;
        }
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        return Text.decode(buffer);
    }

    public static <T> int lowerBound(List<? extends T> list, T key, Comparator<? super T> cmp) {
        int low = 0;
        int high = list.size();
        while (low < high) {
            int mid = low + high >>> 1;
            T midVal = list.get(mid);
            int ret = cmp.compare(midVal, key);
            if (ret < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    public static <T> int upperBound(List<? extends T> list, T key, Comparator<? super T> cmp) {
        int low = 0;
        int high = list.size();
        while (low < high) {
            int mid = low + high >>> 1;
            T midVal = list.get(mid);
            int ret = cmp.compare(midVal, key);
            if (ret <= 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    public static <T> int lowerBound(List<? extends Comparable<? super T>> list, T key) {
        int low = 0;
        int high = list.size();
        while (low < high) {
            int mid = low + high >>> 1;
            Comparable<T> midVal = list.get(mid);
            int ret = midVal.compareTo(key);
            if (ret < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    public static <T> int upperBound(List<? extends Comparable<? super T>> list, T key) {
        int low = 0;
        int high = list.size();
        while (low < high) {
            int mid = low + high >>> 1;
            Comparable<T> midVal = list.get(mid);
            int ret = midVal.compareTo(key);
            if (ret <= 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    public static final class Version
    implements Comparable<Version> {
        private final short major;
        private final short minor;

        public Version(DataInput in) throws IOException {
            this.major = in.readShort();
            this.minor = in.readShort();
        }

        public Version(short major, short minor) {
            this.major = major;
            this.minor = minor;
        }

        public void write(DataOutput out) throws IOException {
            out.writeShort(this.major);
            out.writeShort(this.minor);
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public static int size() {
            return 4;
        }

        public String toString() {
            return "v" + this.major + "." + this.minor;
        }

        public boolean compatibleWith(Version other) {
            return this.major == other.major;
        }

        @Override
        public int compareTo(Version that) {
            if (this.major != that.major) {
                return this.major - that.major;
            }
            return this.minor - that.minor;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            return this.compareTo((Version)other) == 0;
        }

        public int hashCode() {
            return this.major << 16 + this.minor;
        }
    }
}

