/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import oadd.org.apache.hadoop.io.compress.Decompressor;
import oadd.org.apache.hadoop.io.compress.DirectDecompressor;
import oadd.org.apache.hadoop.util.NativeCodeLoader;

public class ZlibDecompressor
implements Decompressor {
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    private static Class clazz = ZlibDecompressor.class;
    private long stream;
    private CompressionHeader header;
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int compressedDirectBufOff;
    private int compressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finished;
    private boolean needDict;
    private static boolean nativeZlibLoaded = false;

    static boolean isNativeZlibLoaded() {
        return nativeZlibLoaded;
    }

    public ZlibDecompressor(CompressionHeader header, int directBufferSize) {
        this.header = header;
        this.directBufferSize = directBufferSize;
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf.position(directBufferSize);
        this.stream = ZlibDecompressor.init(this.header.windowBits());
    }

    public ZlibDecompressor() {
        this(CompressionHeader.DEFAULT_HEADER, 65536);
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
    }

    void setInputFromSavedData() {
        this.compressedDirectBufOff = 0;
        this.compressedDirectBufLen = this.userBufLen;
        if (this.compressedDirectBufLen > this.directBufferSize) {
            this.compressedDirectBufLen = this.directBufferSize;
        }
        this.compressedDirectBuf.rewind();
        ((ByteBuffer)this.compressedDirectBuf).put(this.userBuf, this.userBufOff, this.compressedDirectBufLen);
        this.userBufOff += this.compressedDirectBufLen;
        this.userBufLen -= this.compressedDirectBufLen;
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
        if (this.stream == 0L || b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZlibDecompressor.setDictionary(this.stream, b, off, len);
        this.needDict = false;
    }

    @Override
    public boolean needsInput() {
        if (this.uncompressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.compressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    @Override
    public boolean needsDictionary() {
        return this.needDict;
    }

    @Override
    public boolean finished() {
        return this.finished && this.uncompressedDirectBuf.remaining() == 0;
    }

    @Override
    public int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = 0;
        n = this.uncompressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
            return n;
        }
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        n = this.inflateBytesDirect();
        this.uncompressedDirectBuf.limit(n);
        n = Math.min(n, len);
        ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
        return n;
    }

    public long getBytesWritten() {
        this.checkStream();
        return ZlibDecompressor.getBytesWritten(this.stream);
    }

    public long getBytesRead() {
        this.checkStream();
        return ZlibDecompressor.getBytesRead(this.stream);
    }

    @Override
    public int getRemaining() {
        this.checkStream();
        return this.userBufLen + ZlibDecompressor.getRemaining(this.stream);
    }

    @Override
    public void reset() {
        this.checkStream();
        ZlibDecompressor.reset(this.stream);
        this.finished = false;
        this.needDict = false;
        this.compressedDirectBufLen = 0;
        this.compressedDirectBufOff = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    @Override
    public void end() {
        if (this.stream != 0L) {
            ZlibDecompressor.end(this.stream);
            this.stream = 0L;
        }
    }

    protected void finalize() {
        this.end();
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(int var0);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int inflateBytesDirect();

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native int getRemaining(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int inflateDirect(ByteBuffer src, ByteBuffer dst) throws IOException {
        assert (this instanceof ZlibDirectDecompressor);
        ByteBuffer presliced = dst;
        if (dst.position() > 0) {
            presliced = dst;
            dst = dst.slice();
        }
        Buffer originalCompressed = this.compressedDirectBuf;
        Buffer originalUncompressed = this.uncompressedDirectBuf;
        int originalBufferSize = this.directBufferSize;
        this.compressedDirectBuf = src;
        this.compressedDirectBufOff = src.position();
        this.compressedDirectBufLen = src.remaining();
        this.uncompressedDirectBuf = dst;
        this.directBufferSize = dst.remaining();
        int n = 0;
        try {
            n = this.inflateBytesDirect();
            presliced.position(presliced.position() + n);
            if (this.compressedDirectBufLen > 0) {
                src.position(this.compressedDirectBufOff);
            } else {
                src.position(src.limit());
            }
        }
        finally {
            this.compressedDirectBuf = originalCompressed;
            this.uncompressedDirectBuf = originalUncompressed;
            this.compressedDirectBufOff = 0;
            this.compressedDirectBufLen = 0;
            this.directBufferSize = originalBufferSize;
        }
        return n;
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZlibDecompressor.initIDs();
                nativeZlibLoaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class ZlibDirectDecompressor
    extends ZlibDecompressor
    implements DirectDecompressor {
        private boolean endOfInput;

        public ZlibDirectDecompressor() {
            super(CompressionHeader.DEFAULT_HEADER, 0);
        }

        public ZlibDirectDecompressor(CompressionHeader header, int directBufferSize) {
            super(header, directBufferSize);
        }

        @Override
        public boolean finished() {
            return this.endOfInput && super.finished();
        }

        @Override
        public void reset() {
            super.reset();
            this.endOfInput = true;
        }

        @Override
        public void decompress(ByteBuffer src, ByteBuffer dst) throws IOException {
            assert (dst.isDirect()) : "dst.isDirect()";
            assert (src.isDirect()) : "src.isDirect()";
            assert (dst.remaining() > 0) : "dst.remaining() > 0";
            this.inflateDirect(src, dst);
            this.endOfInput = !src.hasRemaining();
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("byte[] arrays are not supported for DirectDecompressor");
        }

        @Override
        public int decompress(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("byte[] arrays are not supported for DirectDecompressor");
        }
    }

    public static enum CompressionHeader {
        NO_HEADER(-15),
        DEFAULT_HEADER(15),
        GZIP_FORMAT(31),
        AUTODETECT_GZIP_ZLIB(47);

        private final int windowBits;

        private CompressionHeader(int windowBits) {
            this.windowBits = windowBits;
        }

        public int windowBits() {
            return this.windowBits;
        }
    }
}

