/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.util.zip.Deflater;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.compress.Compressor;
import oadd.org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import oadd.org.apache.hadoop.io.compress.zlib.ZlibFactory;

public class BuiltInZlibDeflater
extends Deflater
implements Compressor {
    private static final Log LOG = LogFactory.getLog(BuiltInZlibDeflater.class);

    public BuiltInZlibDeflater(int level, boolean nowrap) {
        super(level, nowrap);
    }

    public BuiltInZlibDeflater(int level) {
        super(level);
    }

    public BuiltInZlibDeflater() {
    }

    @Override
    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        return super.deflate(b, off, len);
    }

    @Override
    public void reinit(Configuration conf) {
        this.reset();
        if (conf == null) {
            return;
        }
        this.setLevel(ZlibFactory.getCompressionLevel(conf).compressionLevel());
        ZlibCompressor.CompressionStrategy strategy = ZlibFactory.getCompressionStrategy(conf);
        try {
            this.setStrategy(strategy.compressionStrategy());
        }
        catch (IllegalArgumentException ill) {
            LOG.warn((Object)((Object)strategy) + " not supported by BuiltInZlibDeflater.");
            this.setStrategy(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reinit compressor with new compression configuration");
        }
    }
}

