/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.OutputStream;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.io.compress.CodecPool;
import oadd.org.apache.hadoop.io.compress.Compressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CompressionOutputStream
extends OutputStream {
    protected final OutputStream out;
    private Compressor trackedCompressor;

    protected CompressionOutputStream(OutputStream out) {
        this.out = out;
    }

    void setTrackedCompressor(Compressor compressor) {
        this.trackedCompressor = compressor;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
        if (this.trackedCompressor != null) {
            CodecPool.returnCompressor(this.trackedCompressor);
            this.trackedCompressor = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void finish() throws IOException;

    public abstract void resetState() throws IOException;
}

