/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io;

import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import oadd.org.apache.commons.codec.binary.Base64;
import oadd.org.apache.commons.io.Charsets;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.DataInputBuffer;
import oadd.org.apache.hadoop.io.DataOutputBuffer;
import oadd.org.apache.hadoop.io.Stringifier;
import oadd.org.apache.hadoop.io.serializer.Deserializer;
import oadd.org.apache.hadoop.io.serializer.SerializationFactory;
import oadd.org.apache.hadoop.io.serializer.Serializer;
import oadd.org.apache.hadoop.util.GenericsUtil;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DefaultStringifier<T>
implements Stringifier<T> {
    private static final String SEPARATOR = ",";
    private Serializer<T> serializer;
    private Deserializer<T> deserializer;
    private DataInputBuffer inBuf;
    private DataOutputBuffer outBuf;

    public DefaultStringifier(Configuration conf, Class<T> c) {
        SerializationFactory factory = new SerializationFactory(conf);
        this.serializer = factory.getSerializer(c);
        this.deserializer = factory.getDeserializer(c);
        this.inBuf = new DataInputBuffer();
        this.outBuf = new DataOutputBuffer();
        try {
            this.serializer.open(this.outBuf);
            this.deserializer.open(this.inBuf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public T fromString(String str) throws IOException {
        try {
            byte[] bytes = Base64.decodeBase64(str.getBytes("UTF-8"));
            this.inBuf.reset(bytes, bytes.length);
            T restored = this.deserializer.deserialize(null);
            return restored;
        }
        catch (UnsupportedCharsetException ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public String toString(T obj) throws IOException {
        this.outBuf.reset();
        this.serializer.serialize(obj);
        byte[] buf = new byte[this.outBuf.getLength()];
        System.arraycopy(this.outBuf.getData(), 0, buf, 0, buf.length);
        return new String(Base64.encodeBase64(buf), Charsets.UTF_8);
    }

    @Override
    public void close() throws IOException {
        this.inBuf.close();
        this.outBuf.close();
        this.deserializer.close();
        this.serializer.close();
    }

    public static <K> void store(Configuration conf, K item, String keyName) throws IOException {
        DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, GenericsUtil.getClass(item));
        conf.set(keyName, stringifier.toString(item));
        stringifier.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> K load(Configuration conf, String keyName, Class<K> itemClass) throws IOException {
        try (DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, itemClass);){
            String itemStr = conf.get(keyName);
            K k = stringifier.fromString(itemStr);
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> void storeArray(Configuration conf, K[] items, String keyName) throws IOException {
        try (DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, GenericsUtil.getClass(items[0]));){
            StringBuilder builder = new StringBuilder();
            for (K item : items) {
                builder.append(stringifier.toString(item)).append(SEPARATOR);
            }
            conf.set(keyName, builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> K[] loadArray(Configuration conf, String keyName, Class<K> itemClass) throws IOException {
        try (DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, itemClass);){
            String itemStr = conf.get(keyName);
            ArrayList<K> list = new ArrayList<K>();
            String[] parts = itemStr.split(SEPARATOR);
            for (String part : parts) {
                if (part.isEmpty()) continue;
                list.add(stringifier.fromString(part));
            }
            String[] stringArray = GenericsUtil.toArray(itemClass, list);
            return stringArray;
        }
    }
}

