/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedTimeStampHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class RepeatedTimeStampHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeStampHolder holder = new NullableTimeStampHolder();
    private int index = -1;
    private RepeatedTimeStampHolder repeatedHolder;

    public RepeatedTimeStampHolderReaderImpl(RepeatedTimeStampHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedTimeStampHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public LocalDateTime readLocalDateTime(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        LocalDateTime value = this.readLocalDateTime();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC);
    }

    @Override
    public Object readObject() {
        ArrayList<LocalDateTime> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC);
    }
}

