/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class MapUtility {
    private static final String TYPE_MISMATCH_ERROR = " does not support heterogeneous value types. All values in the input map must be of the same type. The field [%s] has a differing type [%s].";

    public static void writeToMapFromReader(FieldReader fieldReader, BaseWriter.MapWriter mapWriter, String caller) {
        try {
            TypeProtos.MajorType valueMajorType = fieldReader.getType();
            TypeProtos.MinorType valueMinorType = valueMajorType.getMinorType();
            boolean repeated = false;
            if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                repeated = true;
            }
            switch (valueMinorType) {
                case TINYINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").tinyInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.tinyInt("value"));
                    break;
                }
                case SMALLINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").smallInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.smallInt("value"));
                    break;
                }
                case BIGINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").bigInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.bigInt("value"));
                    break;
                }
                case INT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").integer());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.integer("value"));
                    break;
                }
                case UINT1: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt1());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt1("value"));
                    break;
                }
                case UINT2: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt2());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt2("value"));
                    break;
                }
                case UINT4: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt4());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt4("value"));
                    break;
                }
                case UINT8: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt8());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt8("value"));
                    break;
                }
                case DECIMAL9: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal9());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal9("value"));
                    break;
                }
                case DECIMAL18: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal18());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal18("value"));
                    break;
                }
                case DECIMAL28SPARSE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal28Sparse());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal28Sparse("value"));
                    break;
                }
                case DECIMAL38SPARSE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal38Sparse());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal38Sparse("value"));
                    break;
                }
                case VARDECIMAL: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").varDecimal(valueMajorType.getScale(), valueMajorType.getPrecision()));
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varDecimal("value", valueMajorType.getScale(), valueMajorType.getPrecision()));
                    break;
                }
                case DATE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").date());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.date("value"));
                    break;
                }
                case TIME: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").time());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.time("value"));
                    break;
                }
                case TIMESTAMP: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").timeStamp());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.timeStamp("value"));
                    break;
                }
                case INTERVAL: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").interval());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.interval("value"));
                    break;
                }
                case INTERVALDAY: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").intervalDay());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.intervalDay("value"));
                    break;
                }
                case INTERVALYEAR: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").intervalYear());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.intervalYear("value"));
                    break;
                }
                case FLOAT4: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").float4());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.float4("value"));
                    break;
                }
                case FLOAT8: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").float8());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.float8("value"));
                    break;
                }
                case BIT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").bit());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.bit("value"));
                    break;
                }
                case VARCHAR: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").varChar());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varChar("value"));
                    break;
                }
                case VARBINARY: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").varBinary());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varBinary("value"));
                    break;
                }
                case MAP: {
                    if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                        fieldReader.copyAsValue(mapWriter.list("value").map());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.map("value"));
                    break;
                }
                case LIST: {
                    fieldReader.copyAsValue(mapWriter.list("value").list());
                    break;
                }
                default: {
                    throw new DrillRuntimeException(String.format(caller + " does not support input of type: %s", valueMinorType));
                }
            }
        }
        catch (ClassCastException e) {
            MaterializedField field = fieldReader.getField();
            throw new DrillRuntimeException(String.format(caller + TYPE_MISMATCH_ERROR, field.getName(), field.getType()));
        }
    }

    public static void writeToMapFromReader(FieldReader fieldReader, BaseWriter.MapWriter mapWriter, String fieldName, String caller) {
        try {
            TypeProtos.MajorType valueMajorType = fieldReader.getType();
            TypeProtos.MinorType valueMinorType = valueMajorType.getMinorType();
            boolean repeated = false;
            if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                repeated = true;
            }
            switch (valueMinorType) {
                case TINYINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).tinyInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.tinyInt(fieldName));
                    break;
                }
                case SMALLINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).smallInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.smallInt(fieldName));
                    break;
                }
                case BIGINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).bigInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.bigInt(fieldName));
                    break;
                }
                case INT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).integer());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.integer(fieldName));
                    break;
                }
                case UINT1: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).uInt1());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt1(fieldName));
                    break;
                }
                case UINT2: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).uInt2());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt2(fieldName));
                    break;
                }
                case UINT4: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).uInt4());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt4(fieldName));
                    break;
                }
                case UINT8: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).uInt8());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt8(fieldName));
                    break;
                }
                case DECIMAL9: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).decimal9());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal9(fieldName));
                    break;
                }
                case DECIMAL18: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).decimal18());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal18(fieldName));
                    break;
                }
                case DECIMAL28SPARSE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).decimal28Sparse());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal28Sparse(fieldName));
                    break;
                }
                case DECIMAL38SPARSE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).decimal38Sparse());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal38Sparse(fieldName));
                    break;
                }
                case VARDECIMAL: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).varDecimal(valueMajorType.getScale(), valueMajorType.getPrecision()));
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varDecimal(fieldName, valueMajorType.getScale(), valueMajorType.getPrecision()));
                    break;
                }
                case DATE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).date());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.date(fieldName));
                    break;
                }
                case TIME: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).time());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.time(fieldName));
                    break;
                }
                case TIMESTAMP: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).timeStamp());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.timeStamp(fieldName));
                    break;
                }
                case INTERVAL: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).interval());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.interval(fieldName));
                    break;
                }
                case INTERVALDAY: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).intervalDay());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.intervalDay(fieldName));
                    break;
                }
                case INTERVALYEAR: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).intervalYear());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.intervalYear(fieldName));
                    break;
                }
                case FLOAT4: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).float4());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.float4(fieldName));
                    break;
                }
                case FLOAT8: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).float8());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.float8(fieldName));
                    break;
                }
                case BIT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).bit());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.bit(fieldName));
                    break;
                }
                case VARCHAR: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).varChar());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varChar(fieldName));
                    break;
                }
                case VARBINARY: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).varBinary());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varBinary(fieldName));
                    break;
                }
                case MAP: {
                    if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                        fieldReader.copyAsValue(mapWriter.list(fieldName).map());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.map(fieldName));
                    break;
                }
                case LIST: {
                    fieldReader.copyAsValue(mapWriter.list(fieldName).list());
                    break;
                }
                default: {
                    throw new DrillRuntimeException(String.format(caller + " does not support input of type: %s", valueMinorType));
                }
            }
        }
        catch (ClassCastException e) {
            MaterializedField field = fieldReader.getField();
            throw new DrillRuntimeException(String.format(caller + TYPE_MISMATCH_ERROR, field.getName(), field.getType()));
        }
    }

    public static void writeToListFromReader(FieldReader fieldReader, BaseWriter.ListWriter listWriter, String caller) {
        try {
            TypeProtos.MajorType valueMajorType = fieldReader.getType();
            TypeProtos.MinorType valueMinorType = valueMajorType.getMinorType();
            boolean repeated = false;
            if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                repeated = true;
            }
            switch (valueMinorType) {
                case TINYINT: {
                    fieldReader.copyAsValue(listWriter.tinyInt());
                    break;
                }
                case SMALLINT: {
                    fieldReader.copyAsValue(listWriter.smallInt());
                    break;
                }
                case BIGINT: {
                    fieldReader.copyAsValue(listWriter.bigInt());
                    break;
                }
                case INT: {
                    fieldReader.copyAsValue(listWriter.integer());
                    break;
                }
                case UINT1: {
                    fieldReader.copyAsValue(listWriter.uInt1());
                    break;
                }
                case UINT2: {
                    fieldReader.copyAsValue(listWriter.uInt2());
                    break;
                }
                case UINT4: {
                    fieldReader.copyAsValue(listWriter.uInt4());
                    break;
                }
                case UINT8: {
                    fieldReader.copyAsValue(listWriter.uInt8());
                    break;
                }
                case DECIMAL9: {
                    fieldReader.copyAsValue(listWriter.decimal9());
                    break;
                }
                case DECIMAL18: {
                    fieldReader.copyAsValue(listWriter.decimal18());
                    break;
                }
                case DECIMAL28SPARSE: {
                    fieldReader.copyAsValue(listWriter.decimal28Sparse());
                    break;
                }
                case DECIMAL38SPARSE: {
                    fieldReader.copyAsValue(listWriter.decimal38Sparse());
                    break;
                }
                case VARDECIMAL: {
                    fieldReader.copyAsValue(listWriter.varDecimal(valueMajorType.getScale(), valueMajorType.getPrecision()));
                    break;
                }
                case DATE: {
                    fieldReader.copyAsValue(listWriter.date());
                    break;
                }
                case TIME: {
                    fieldReader.copyAsValue(listWriter.time());
                    break;
                }
                case TIMESTAMP: {
                    fieldReader.copyAsValue(listWriter.timeStamp());
                    break;
                }
                case INTERVAL: {
                    fieldReader.copyAsValue(listWriter.interval());
                    break;
                }
                case INTERVALDAY: {
                    fieldReader.copyAsValue(listWriter.intervalDay());
                    break;
                }
                case INTERVALYEAR: {
                    fieldReader.copyAsValue(listWriter.intervalYear());
                    break;
                }
                case FLOAT4: {
                    fieldReader.copyAsValue(listWriter.float4());
                    break;
                }
                case FLOAT8: {
                    fieldReader.copyAsValue(listWriter.float8());
                    break;
                }
                case BIT: {
                    fieldReader.copyAsValue(listWriter.bit());
                    break;
                }
                case VARCHAR: {
                    fieldReader.copyAsValue(listWriter.varChar());
                    break;
                }
                case VARBINARY: {
                    fieldReader.copyAsValue(listWriter.varBinary());
                    break;
                }
                case MAP: {
                    fieldReader.copyAsValue(listWriter.map());
                    break;
                }
                case LIST: {
                    fieldReader.copyAsValue(listWriter.list());
                    break;
                }
                default: {
                    throw new DrillRuntimeException(String.format(caller + " function does not support input of type: %s", valueMinorType));
                }
            }
        }
        catch (ClassCastException e) {
            MaterializedField field = fieldReader.getField();
            throw new DrillRuntimeException(String.format(caller + TYPE_MISMATCH_ERROR, field.getName(), field.getType()));
        }
    }
}

