/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractFixedWidthWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriter;

public class OffsetVectorWriterImpl
extends AbstractFixedWidthWriter
implements OffsetVectorWriter {
    private static final int VALUE_WIDTH = 4;
    private final UInt4Vector vector;
    private int rowStartOffset;
    private int nextOffset;

    public OffsetVectorWriterImpl(UInt4Vector vector) {
        this.vector = vector;
    }

    @Override
    public BaseDataValueVector vector() {
        return this.vector;
    }

    @Override
    public int width() {
        return 4;
    }

    @Override
    protected void realloc(int size) {
        this.vector.reallocRaw(size);
        this.setBuffer();
    }

    @Override
    public ValueType valueType() {
        return ValueType.INTEGER;
    }

    @Override
    public void startWrite() {
        super.startWrite();
        this.nextOffset = 0;
        this.rowStartOffset = 0;
        if (this.capacity * 4 < 256) {
            this.realloc(256);
        }
        this.drillBuf.setInt(0, 0);
    }

    @Override
    public int nextOffset() {
        return this.nextOffset;
    }

    @Override
    public int rowStartOffset() {
        return this.rowStartOffset;
    }

    @Override
    public void startRow() {
        this.rowStartOffset = this.nextOffset;
    }

    protected final int prepareWrite() {
        int valueIndex = this.vectorIndex.vectorIndex();
        int writeIndex = valueIndex + 1;
        if (this.lastWriteIndex + 1 < valueIndex || writeIndex >= this.capacity) {
            writeIndex = this.prepareWrite(writeIndex);
        }
        this.lastWriteIndex = valueIndex;
        return writeIndex;
    }

    protected int prepareWrite(int writeIndex) {
        this.resize(writeIndex);
        int valueIndex = this.vectorIndex.vectorIndex();
        this.fillEmpties(valueIndex);
        return valueIndex + 1;
    }

    @Override
    protected final void fillEmpties(int valueIndex) {
        while (this.lastWriteIndex < valueIndex - 1) {
            this.drillBuf.setInt((++this.lastWriteIndex + 1) * 4, this.nextOffset);
        }
    }

    @Override
    public final void setNextOffset(int newOffset) {
        int writeIndex = this.prepareWrite();
        this.drillBuf.setInt(writeIndex * 4, newOffset);
        this.nextOffset = newOffset;
    }

    @Override
    public void skipNulls() {
    }

    @Override
    public void restartRow() {
        this.nextOffset = this.rowStartOffset;
        super.restartRow();
    }

    @Override
    public void preRollover() {
        this.setValueCount(this.vectorIndex.rowStartIndex() + 1);
    }

    @Override
    public void postRollover() {
        int newNext = this.nextOffset - this.rowStartOffset;
        super.postRollover();
        this.nextOffset = newNext;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.mandatoryResize(valueCount);
        this.fillEmpties(valueCount);
        this.vector().getBuffer().writerIndex((valueCount + 1) * 4);
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("lastWriteIndex", this.lastWriteIndex).attribute("nextOffset", this.nextOffset).endObject();
    }
}

