/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.math.BigDecimal;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriter;
import oadd.org.joda.time.Period;

public abstract class BaseScalarWriter
extends AbstractScalarWriter {
    public static final int MIN_BUFFER_SIZE = 256;
    protected ScalarWriter.ColumnWriterListener listener;
    protected DrillBuf drillBuf;
    protected int capacity;

    @Override
    public void bindListener(ScalarWriter.ColumnWriterListener listener) {
        this.listener = listener;
    }

    protected abstract void setBuffer();

    protected void realloc(int size) {
        this.vector().reallocRaw(size);
        this.setBuffer();
    }

    protected boolean canExpand(int delta) {
        if (this.listener == null) {
            return true;
        }
        return this.listener.canExpand(this, delta);
    }

    protected void overflowed() {
        if (this.listener == null) {
            throw new UnsupportedOperationException("Overflow not supported");
        }
        this.listener.overflowed(this);
    }

    public abstract void skipNulls();

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void setNull() {
        throw UnsupportedConversionError.nullError(this.schema());
    }

    @Override
    public void setInt(int value) {
        throw this.conversionError("int");
    }

    @Override
    public void setLong(long value) {
        throw this.conversionError("long");
    }

    @Override
    public void setDouble(double value) {
        throw this.conversionError("double");
    }

    @Override
    public void setString(String value) {
        throw this.conversionError("String");
    }

    @Override
    public void setBytes(byte[] value, int len) {
        throw this.conversionError("bytes");
    }

    @Override
    public void setDecimal(BigDecimal value) {
        throw this.conversionError("Decimal");
    }

    @Override
    public void setPeriod(Period value) {
        throw this.conversionError("Period");
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("vectorIndex", this.vectorIndex).attributeIdentity("listener", this.listener).attribute("capacity", this.capacity).endObject();
    }
}

