/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oadd.com.dyuproject.protostuff.JsonIOUtil;
import oadd.com.dyuproject.protostuff.Schema;
import oadd.com.google.common.base.Objects;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.protobuf.Message;
import oadd.org.apache.drill.exec.serialization.InstanceSerializer;

public class ProtoSerializer<T, B extends Message.Builder>
implements InstanceSerializer<T> {
    private final Schema<B> readSchema;
    private final Schema<T> writeSchema;

    public ProtoSerializer(Schema<B> readSchema, Schema<T> writeSchema) {
        this.readSchema = Preconditions.checkNotNull(readSchema);
        this.writeSchema = Preconditions.checkNotNull(writeSchema);
    }

    @Override
    public T deserialize(byte[] raw) throws IOException {
        Message.Builder builder = (Message.Builder)this.readSchema.newMessage();
        JsonIOUtil.mergeFrom((byte[])raw, (Object)builder, this.readSchema, (boolean)false);
        return (T)builder.build();
    }

    @Override
    public byte[] serialize(T instance) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonIOUtil.writeTo((OutputStream)out, instance, this.writeSchema, (boolean)false);
        return out.toByteArray();
    }

    public int hashCode() {
        return Objects.hashCode(this.readSchema, this.writeSchema);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProtoSerializer && obj.getClass().equals(this.getClass())) {
            ProtoSerializer other = (ProtoSerializer)obj;
            return Objects.equal(this.readSchema, other.readSchema) && Objects.equal(this.writeSchema, other.writeSchema);
        }
        return false;
    }
}

